/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.network.handler;

import com.direwolf20.justdirethings.common.containers.basecontainers.BaseMachineContainer;
import com.direwolf20.justdirethings.common.network.data.TickSpeedPayload;
import com.direwolf20.justdirethings.setup.Config;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class TickSpeedPacket {
    public static final TickSpeedPacket INSTANCE = new TickSpeedPacket();

    public static TickSpeedPacket get() {
        return INSTANCE;
    }

    public void handle(TickSpeedPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Optional senderOptional = context.player();
            if (senderOptional.isEmpty()) {
                return;
            }
            Player sender = (Player)senderOptional.get();
            AbstractContainerMenu container = sender.containerMenu;
            if (container instanceof BaseMachineContainer) {
                BaseMachineContainer baseMachineContainer = (BaseMachineContainer)container;
                baseMachineContainer.baseMachineBE.setTickSpeed(Math.min(Math.max(payload.tickSpeed(), (Integer)Config.MINIMUM_MACHINE_TICK_SPEED.get()), 1200));
            }
        });
    }
}

