/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.network.handler;

import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.common.network.data.ToggleToolSlotPayload;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ToggleToolSlotPacket {
    public static final ToggleToolSlotPacket INSTANCE = new ToggleToolSlotPacket();

    public static ToggleToolSlotPacket get() {
        return INSTANCE;
    }

    public void handle(ToggleToolSlotPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Optional senderOptional = context.player();
            if (senderOptional.isEmpty()) {
                return;
            }
            Player player = (Player)senderOptional.get();
            ItemStack stack = player.getInventory().getItem(payload.slot());
            if (stack.getItem() instanceof ToggleableTool) {
                if (payload.type() == 0) {
                    ToggleableTool.toggleSetting(stack, payload.settingName());
                } else if (payload.type() == 1) {
                    ToggleableTool.cycleSetting(stack, payload.settingName());
                } else if (payload.type() == 2) {
                    ToggleableTool.setToolValue(stack, payload.settingName(), payload.value());
                }
            }
        });
    }
}

