/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.datagen.recipes;

import com.direwolf20.justdirethings.common.blockentities.basebe.GooBlockBE_Base;
import com.direwolf20.justdirethings.setup.Registration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class GooSpreadRecipe
implements CraftingRecipe {
    private final ResourceLocation id;
    protected final BlockState input;
    protected final BlockState output;
    protected int tierRequirement;
    protected int craftingDuration;

    public GooSpreadRecipe(ResourceLocation id, BlockState input, BlockState output, int tierRequirement, int craftingDuration) {
        this.id = id;
        this.input = input;
        this.output = output;
        this.tierRequirement = tierRequirement;
        this.craftingDuration = craftingDuration;
    }

    public RecipeType<?> getType() {
        return Registration.GOO_SPREAD_RECIPE_TYPE.get();
    }

    public boolean matches(Level level, BlockPos blockPos, GooBlockBE_Base gooBlockBE_base, BlockState sourceState) {
        return sourceState.equals(this.input) && gooBlockBE_base.getTier() >= this.tierRequirement;
    }

    public BlockState getOutput() {
        return this.output;
    }

    public BlockState getInput() {
        return this.input;
    }

    public int getTierRequirement() {
        return this.tierRequirement;
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public ItemStack getResultItem(RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        return false;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.GOO_SPREAD_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<GooSpreadRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("justdirethings", "goospread");
        private static final Codec<GooSpreadRecipe> CODEC = RecordCodecBuilder.create(p_311734_ -> p_311734_.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(p_301134_ -> p_301134_.id), (App)BlockState.CODEC.fieldOf("input").forGetter(p_301135_ -> p_301135_.input), (App)BlockState.CODEC.fieldOf("output").forGetter(p_301136_ -> p_301136_.output), (App)Codec.INT.fieldOf("tierRequirement").forGetter(p_301137_ -> p_301137_.tierRequirement), (App)Codec.INT.fieldOf("craftingDuration").forGetter(p_301138_ -> p_301138_.craftingDuration)).apply((Applicative)p_311734_, GooSpreadRecipe::new));

        public Codec<GooSpreadRecipe> codec() {
            return CODEC;
        }

        public GooSpreadRecipe fromNetwork(FriendlyByteBuf pBuffer) {
            ResourceLocation resourceLocation = pBuffer.readResourceLocation();
            BlockState inputState = Block.stateById((int)pBuffer.readInt());
            BlockState outputState = Block.stateById((int)pBuffer.readInt());
            int tierRequirement = pBuffer.readInt();
            int craftingDuration = pBuffer.readInt();
            return new GooSpreadRecipe(resourceLocation, inputState, outputState, tierRequirement, craftingDuration);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, GooSpreadRecipe pRecipe) {
            pBuffer.writeResourceLocation(pRecipe.id);
            pBuffer.writeInt(Block.getId((BlockState)pRecipe.input));
            pBuffer.writeInt(Block.getId((BlockState)pRecipe.output));
            pBuffer.writeInt(pRecipe.tierRequirement);
            pBuffer.writeInt(pRecipe.craftingDuration);
        }
    }
}

