/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.setup;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.client.blockentityrenders.BlockBreakerT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.BlockPlacerT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.BlockSwapperT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.ClickerT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.DropperT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.EclipseGateRenderer;
import com.direwolf20.justdirethings.client.blockentityrenders.EnergyTransmitterRenderer;
import com.direwolf20.justdirethings.client.blockentityrenders.ItemCollectorRenderer;
import com.direwolf20.justdirethings.client.blockentityrenders.SensorT2BER;
import com.direwolf20.justdirethings.client.blockentityrenders.gooblocks.GooBlockRender_Tier1;
import com.direwolf20.justdirethings.client.blockentityrenders.gooblocks.GooBlockRender_Tier2;
import com.direwolf20.justdirethings.client.blockentityrenders.gooblocks.GooBlockRender_Tier3;
import com.direwolf20.justdirethings.client.blockentityrenders.gooblocks.GooBlockRender_Tier4;
import com.direwolf20.justdirethings.client.events.EventKeyInput;
import com.direwolf20.justdirethings.client.events.PlayerEvents;
import com.direwolf20.justdirethings.client.events.RenderHighlight;
import com.direwolf20.justdirethings.client.events.RenderLevelLast;
import com.direwolf20.justdirethings.client.screens.BlockBreakerT1Screen;
import com.direwolf20.justdirethings.client.screens.BlockBreakerT2Screen;
import com.direwolf20.justdirethings.client.screens.BlockPlacerT1Screen;
import com.direwolf20.justdirethings.client.screens.BlockPlacerT2Screen;
import com.direwolf20.justdirethings.client.screens.BlockSwapperT1Screen;
import com.direwolf20.justdirethings.client.screens.BlockSwapperT2Screen;
import com.direwolf20.justdirethings.client.screens.ClickerT1Screen;
import com.direwolf20.justdirethings.client.screens.ClickerT2Screen;
import com.direwolf20.justdirethings.client.screens.DropperT1Screen;
import com.direwolf20.justdirethings.client.screens.DropperT2Screen;
import com.direwolf20.justdirethings.client.screens.EnergyTransmitterScreen;
import com.direwolf20.justdirethings.client.screens.FuelCanisterScreen;
import com.direwolf20.justdirethings.client.screens.GeneratorT1Screen;
import com.direwolf20.justdirethings.client.screens.ItemCollectorScreen;
import com.direwolf20.justdirethings.client.screens.PlayerAccessorScreen;
import com.direwolf20.justdirethings.client.screens.PocketGeneratorScreen;
import com.direwolf20.justdirethings.client.screens.SensorT1Screen;
import com.direwolf20.justdirethings.client.screens.SensorT2Screen;
import com.direwolf20.justdirethings.client.screens.ToolSettingScreen;
import com.direwolf20.justdirethings.common.items.PocketGenerator;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.NBTHelpers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.DeferredHolder;

@Mod.EventBusSubscriber(modid="justdirethings", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.addListener(KeyBindings::onClientInput);
        NeoForge.EVENT_BUS.register(RenderLevelLast.class);
        NeoForge.EVENT_BUS.register(EventKeyInput.class);
        NeoForge.EVENT_BUS.register(RenderHighlight.class);
        NeoForge.EVENT_BUS.register(PlayerEvents.class);
        event.enqueueWork(() -> {
            for (DeferredHolder tool : Registration.TOOLS.getEntries()) {
                ClientSetup.registerEnabledToolTextures((Item)tool.get());
            }
            ClientSetup.registerEnabledToolTextures((Item)Registration.Pocket_Generator.get());
        });
    }

    public static void registerEnabledToolTextures(Item tool) {
        if (tool instanceof ToggleableItem) {
            ToggleableItem toggleableItem = (ToggleableItem)tool;
            ItemProperties.register((Item)tool, (ResourceLocation)new ResourceLocation("justdirethings", "enabled"), (stack, level, living, id) -> {
                if (stack.getItem() instanceof PocketGenerator) {
                    if (!toggleableItem.getEnabled(stack)) {
                        return 0.0f;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                    if (energyStorage == null) {
                        return 0.0f;
                    }
                    if (energyStorage.getEnergyStored() > 0) {
                        return 1.0f;
                    }
                    if (NBTHelpers.getIntValue(stack, "counter") <= 0) {
                        return 0.0f;
                    }
                    return 1.0f;
                }
                return toggleableItem.getEnabled(stack) ? 1.0f : 0.0f;
            });
        }
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)Registration.FuelCanister_Container.get(), FuelCanisterScreen::new);
        event.register((MenuType)Registration.PocketGenerator_Container.get(), PocketGeneratorScreen::new);
        event.register((MenuType)Registration.Tool_Settings_Container.get(), ToolSettingScreen::new);
        event.register((MenuType)Registration.Item_Collector_Container.get(), ItemCollectorScreen::new);
        event.register((MenuType)Registration.BlockBreakerT1_Container.get(), BlockBreakerT1Screen::new);
        event.register((MenuType)Registration.BlockBreakerT2_Container.get(), BlockBreakerT2Screen::new);
        event.register((MenuType)Registration.BlockPlacerT1_Container.get(), BlockPlacerT1Screen::new);
        event.register((MenuType)Registration.BlockPlacerT2_Container.get(), BlockPlacerT2Screen::new);
        event.register((MenuType)Registration.ClickerT1_Container.get(), ClickerT1Screen::new);
        event.register((MenuType)Registration.ClickerT2_Container.get(), ClickerT2Screen::new);
        event.register((MenuType)Registration.SensorT1_Container.get(), SensorT1Screen::new);
        event.register((MenuType)Registration.SensorT2_Container.get(), SensorT2Screen::new);
        event.register((MenuType)Registration.DropperT1_Container.get(), DropperT1Screen::new);
        event.register((MenuType)Registration.DropperT2_Container.get(), DropperT2Screen::new);
        event.register((MenuType)Registration.GeneratorT1_Container.get(), GeneratorT1Screen::new);
        event.register((MenuType)Registration.EnergyTransmitter_Container.get(), EnergyTransmitterScreen::new);
        event.register((MenuType)Registration.BlockSwapperT1_Container.get(), BlockSwapperT1Screen::new);
        event.register((MenuType)Registration.BlockSwapperT2_Container.get(), BlockSwapperT2Screen::new);
        event.register((MenuType)Registration.PlayerAccessor_Container.get(), PlayerAccessorScreen::new);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Registration.GooBlockBE_Tier1.get(), GooBlockRender_Tier1::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.GooBlockBE_Tier2.get(), GooBlockRender_Tier2::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.GooBlockBE_Tier3.get(), GooBlockRender_Tier3::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.GooBlockBE_Tier4.get(), GooBlockRender_Tier4::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.ItemCollectorBE.get(), ItemCollectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.BlockBreakerT2BE.get(), BlockBreakerT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.BlockPlacerT2BE.get(), BlockPlacerT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.ClickerT2BE.get(), ClickerT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.SensorT2BE.get(), SensorT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.DropperT2BE.get(), DropperT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.EnergyTransmitterBE.get(), EnergyTransmitterRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.BlockSwapperT2BE.get(), BlockSwapperT2BER::new);
        event.registerBlockEntityRenderer((BlockEntityType)Registration.EclipseGateBE.get(), EclipseGateRenderer::new);
    }
}

