/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackKey {
    public final Item item;
    public final CompoundTag nbt;
    private final int hash;

    public ItemStackKey(ItemStack stack, boolean compareNBT) {
        this.item = stack.getItem();
        this.nbt = compareNBT ? stack.getTag() : new CompoundTag();
        this.hash = Objects.hash(this.item, this.nbt);
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.item, 1, this.nbt);
    }

    public ItemStack getStack(int amt) {
        return new ItemStack((ItemLike)this.item, amt, this.nbt);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemStackKey) {
            return ((ItemStackKey)obj).item == this.item && Objects.equals(((ItemStackKey)obj).nbt, this.nbt);
        }
        return false;
    }
}

