/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MiscTools {
    @NotNull
    public static BlockHitResult getHitResult(Player player) {
        Vec3 playerLook = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        Vec3 lookVec = player.getViewVector(1.0f);
        double reach = player.getBlockReach();
        Vec3 endLook = playerLook.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
        BlockHitResult hitResult = player.level().clip(new ClipContext(playerLook, endLook, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        return hitResult;
    }

    public static boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }

    public static Vector3f findOffset(Direction direction, int slot, Vector3f[] offsets) {
        Vector3f offsetVector = new Vector3f((Vector3fc)offsets[slot]);
        switch (direction) {
            case UP: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 1.0f, 0.0f);
                break;
            }
            case DOWN: {
                Quaternionf quaternionf = Axis.XP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
                break;
            }
            case EAST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-90.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 0.0f);
                break;
            }
            case SOUTH: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-180.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(1.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                Quaternionf quaternionf = Axis.YP.rotationDegrees(-270.0f);
                offsetVector = quaternionf.transform(offsetVector);
                offsetVector.add(0.0f, 0.0f, 1.0f);
            }
        }
        return offsetVector;
    }

    public static ListTag stringListToNBT(List<String> list) {
        ListTag nbtList = new ListTag();
        for (String string : list) {
            CompoundTag tag = new CompoundTag();
            tag.putString("list", string);
            nbtList.add((Object)tag);
        }
        return nbtList;
    }

    public static List<String> NBTToStringList(ListTag nbtList) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag tag = nbtList.getCompound(i);
            list.add(tag.getString("list"));
        }
        return list;
    }

    public static MutableComponent tooltipMaker(String string, int color) {
        Style style = Style.EMPTY;
        style = style.withColor(color);
        MutableComponent current = Component.translatable((String)string);
        current.setStyle(style);
        return current;
    }
}

