/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.util;

import com.direwolf20.justdirethings.client.KeyBindings;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableItem;
import com.direwolf20.justdirethings.common.items.interfaces.ToggleableTool;
import com.direwolf20.justdirethings.setup.Registration;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.NBTHelpers;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TooltipHelpers {
    public static void appendFEText(ItemStack stack, List<Component> tooltip) {
        Item item = stack.getItem();
        if (!(item instanceof PoweredItem)) {
            return;
        }
        PoweredItem poweredItem = (PoweredItem)item;
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return;
        }
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.festored", (Object[])new Object[]{MagicHelpers.formatted(energy.getEnergyStored()), MagicHelpers.formatted(energy.getMaxEnergyStored())}).withStyle(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"justdirethings.festored", (Object[])new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}).withStyle(ChatFormatting.GREEN));
        }
    }

    public static void appendToolEnabled(ItemStack stack, List<Component> tooltip) {
        Item item = stack.getItem();
        if (item instanceof ToggleableItem) {
            ToggleableItem toggleableItem = (ToggleableItem)item;
            if (toggleableItem.getEnabled(stack)) {
                tooltip.add((Component)Component.translatable((String)"justdirethings.enabled").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"justdirethings.presshotkey", (Object[])new Object[]{KeyBindings.toggleTool.getKey().getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY))));
            } else {
                tooltip.add((Component)Component.translatable((String)"justdirethings.disabled").withStyle(ChatFormatting.DARK_RED).append((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"justdirethings.presshotkey", (Object[])new Object[]{KeyBindings.toggleTool.getKey().getDisplayName()}).withStyle(ChatFormatting.DARK_GRAY))));
            }
        }
    }

    public static void appendAbilityList(ItemStack stack, List<Component> tooltip) {
        Item item = stack.getItem();
        if (item instanceof ToggleableTool) {
            ToggleableTool toggleableTool = (ToggleableTool)item;
            NBTHelpers.BoundInventory boundInventory = ToggleableTool.getBoundInventory(stack);
            for (Ability ability : toggleableTool.getAbilities()) {
                Object dimString;
                boolean active = ToggleableTool.getSetting(stack, ability.getName());
                ChatFormatting chatFormatting = active ? ChatFormatting.GREEN : ChatFormatting.DARK_RED;
                tooltip.add((Component)Component.translatable((String)ability.getLocalization()).withStyle(chatFormatting));
                if (!ability.equals((Object)Ability.DROPTELEPORT)) continue;
                chatFormatting = ChatFormatting.DARK_PURPLE;
                if (boundInventory == null) {
                    dimString = I18n.get((String)"justdirethings.unbound", (Object[])new Object[0]);
                    tooltip.add((Component)Component.literal((String)dimString).withStyle(chatFormatting));
                    continue;
                }
                dimString = " -" + I18n.get((String)boundInventory.globalPos().dimension().location().getPath(), (Object[])new Object[0]) + ": [" + boundInventory.globalPos().pos().toShortString() + "]";
                tooltip.add((Component)Component.literal((String)dimString).withStyle(chatFormatting));
                tooltip.add((Component)Component.literal((String)"").append((Component)Component.translatable((String)"justdirethings.boundside")).append((Component)Component.translatable((String)("justdirethings.screen.direction-" + boundInventory.direction().getName()))).withStyle(chatFormatting));
            }
        }
    }

    public static void appendShiftForInfo(ItemStack stack, List<Component> tooltip) {
        tooltip.add((Component)Component.translatable((String)"justdirethings.shiftmoreinfo").withStyle(ChatFormatting.GRAY));
    }

    public static void appendGeneratorDetails(ItemStack stack, List<Component> tooltip) {
        ItemStackHandler itemStackHandler = (ItemStackHandler)stack.getData(Registration.HANDLER);
        ItemStack fuelStack = itemStackHandler.getStackInSlot(0);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.pocketgeneratorburntime", (Object[])new Object[]{NBTHelpers.getIntValue(stack, "counter"), NBTHelpers.getIntValue(stack, "maxburn")}).withStyle(ChatFormatting.DARK_RED));
            if (fuelStack.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"justdirethings.pocketgeneratornofuel").withStyle(ChatFormatting.RED));
            } else {
                tooltip.add((Component)Component.translatable((String)"justdirethings.pocketgeneratorfuelstack", (Object[])new Object[]{fuelStack.getCount(), fuelStack.getItem().getName(fuelStack)}).withStyle(ChatFormatting.DARK_AQUA));
            }
        } else if (fuelStack.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"justdirethings.pocketgeneratornofuel").withStyle(ChatFormatting.RED));
        }
    }
}

