/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.compat.jei;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.compat.Compatibility;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.packet.PacketChangeItemFilter;
import com.supermartijn642.trashcans.packet.PacketChangeLiquidFilter;
import com.supermartijn642.trashcans.screen.ItemTrashCanScreen;
import com.supermartijn642.trashcans.screen.LiquidTrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import com.supermartijn642.trashcans.screen.TrashCanWidgetContainerScreen;
import com.supermartijn642.trashcans.screen.UltimateTrashCanScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GhostIngredientHandler
implements IGhostIngredientHandler<TrashCanWidgetContainerScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(TrashCanWidgetContainerScreen screen, ITypedIngredient<I> ingredient, boolean doStart) {
        TrashCanScreen<?> widget = screen.getWidget();
        TrashCanContainer container = screen.getContainer();
        ArrayList<Slot> itemFilterSlots = new ArrayList<Slot>();
        ArrayList<Slot> fluidFilterSlots = new ArrayList<Slot>();
        if (widget instanceof ItemTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                itemFilterSlots.add(container.getSlot(slot));
            }
        } else if (widget instanceof LiquidTrashCanScreen) {
            for (slot = 1; slot <= 9; ++slot) {
                fluidFilterSlots.add(container.getSlot(slot));
            }
        } else if (widget instanceof UltimateTrashCanScreen) {
            for (slot = 3; slot <= 11; ++slot) {
                itemFilterSlots.add(container.getSlot(slot));
            }
            for (slot = 12; slot <= 20; ++slot) {
                fluidFilterSlots.add(container.getSlot(slot));
            }
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (int i = 0; i < itemFilterSlots.size(); ++i) {
                int index = i;
                Slot slot = (Slot)itemFilterSlots.get(i);
                Rect2i bounds = new Rect2i(screen.getWidget().left() + slot.x, screen.getWidget().top() + slot.y, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.itemFilter.set(index, (ItemStack)input);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeItemFilter(container.getBlockEntityPos(), index, (ItemStack)input));
                    }
                });
                targets.add(target);
            }
        }
        ItemStack ingredientStack = ItemStack.EMPTY;
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            ingredientStack = (ItemStack)ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).get();
        } else if (Compatibility.MEKANISM.isGasStack(ingredient.getIngredient())) {
            ingredientStack = Compatibility.MEKANISM.getChemicalTankForGasStack(ingredient.getIngredient());
        }
        ItemFilter filter = LiquidTrashCanFilters.createFilter(ingredientStack);
        if (filter != null) {
            for (int i = 0; i < fluidFilterSlots.size(); ++i) {
                int index = i;
                Slot slot = (Slot)fluidFilterSlots.get(i);
                Rect2i bounds = new Rect2i(screen.getWidget().left() + slot.x, screen.getWidget().top() + slot.y, 17, 17);
                IGhostIngredientHandler.Target<Object> target = GhostIngredientHandler.createTarget(bounds, input -> {
                    TrashCanBlockEntity entity = container.getBlockEntity();
                    if (entity != null) {
                        entity.liquidFilter.set(index, filter);
                        TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeLiquidFilter(container.getBlockEntityPos(), index, filter));
                    }
                });
                targets.add(target);
            }
        }
        return targets;
    }

    private static <I> IGhostIngredientHandler.Target<I> createTarget(final Rect2i bounds, final Consumer<I> acceptor) {
        return new IGhostIngredientHandler.Target<I>(){

            public Rect2i getArea() {
                return bounds;
            }

            public void accept(I ingredient) {
                acceptor.accept(ingredient);
            }
        };
    }

    public void onComplete() {
    }
}

