/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class ItemTrashCanContainer
extends TrashCanContainer {
    public ItemTrashCanContainer(Player player, BlockPos pos) {
        super(TrashCans.item_trash_can_container, player, pos, 202, 180);
    }

    protected void addSlots(Player player, TrashCanBlockEntity entity) {
        this.addSlot((Slot)new SlotItemHandler(entity.ITEM_HANDLER, 0, 93, 25));
        for (int column = 0; column < 9; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler(), column, 8 + column * 18, 64){

                public boolean mayPickup(Player playerIn) {
                    return false;
                }
            });
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (!this.validateObjectOrClose()) {
            return;
        }
        if (slotId >= 1 && slotId <= 9) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(slotId - 1, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(slotId - 1, stack);
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (!this.validateObjectOrClose()) {
            return ItemStack.EMPTY;
        }
        if (index >= 1 && index <= 9) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(index - 1, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(index - 1, stack);
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
        } else if (index >= 10 && this.getSlot(0).mayPlace(this.getSlot(index).getItem())) {
            this.getSlot(index).set(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }

    private IItemHandlerModifiable itemHandler() {
        return new ItemStackHandler(9){

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return ItemTrashCanContainer.this.validateObjectOrClose() ? ((TrashCanBlockEntity)((Object)((ItemTrashCanContainer)ItemTrashCanContainer.this).object)).itemFilter.get(slot) : ItemStack.EMPTY;
            }
        };
    }
}

