/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.filter.ItemFilter;
import com.supermartijn642.trashcans.filter.LiquidTrashCanFilters;
import com.supermartijn642.trashcans.screen.TrashCanContainer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class UltimateTrashCanContainer
extends TrashCanContainer {
    public UltimateTrashCanContainer(Player player, BlockPos pos) {
        super(TrashCans.ultimate_trash_can_container, player, pos, 202, 247);
    }

    protected void addSlots(Player player, TrashCanBlockEntity entity) {
        int column;
        this.addSlot((Slot)new SlotItemHandler(entity.ITEM_HANDLER, 0, 63, 25));
        this.addSlot((Slot)new SlotItemHandler(entity.LIQUID_ITEM_HANDLER, 0, 93, 25));
        this.addSlot((Slot)new SlotItemHandler(entity.ENERGY_ITEM_HANDLER, 0, 123, 25));
        for (column = 0; column < 9; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemFilterHandler(), column, 8 + column * 18, 64){

                public boolean mayPickup(Player playerIn) {
                    return false;
                }
            });
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.liquidFilterHandler(), column, 8 + column * 18, 94){

                public boolean mayPickup(Player playerIn) {
                    return false;
                }
            });
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (!this.validateObjectOrClose()) {
            return;
        }
        if (slotId >= 3 && slotId <= 11) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(slotId - 3, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(slotId - 3, stack);
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
            return;
        }
        if (slotId >= 12 && slotId <= 20) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).liquidFilter.set(slotId - 12, null);
            } else {
                ItemFilter filter = LiquidTrashCanFilters.createFilter(this.getCarried());
                if (filter != null) {
                    ((TrashCanBlockEntity)((Object)this.object)).liquidFilter.set(slotId - 12, filter);
                }
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (!this.validateObjectOrClose()) {
            return ItemStack.EMPTY;
        }
        if (index == 1 || index == 2) {
            if (this.moveItemStackTo(this.getSlot(index).getItem(), 21, this.slots.size(), true)) {
                this.getSlot(index).set(ItemStack.EMPTY);
            }
        } else if (index >= 3 && index <= 11) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(index - 3, ItemStack.EMPTY);
            } else {
                ItemStack stack = this.getCarried().copy();
                stack.setCount(1);
                ((TrashCanBlockEntity)((Object)this.object)).itemFilter.set(index - 3, stack);
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
        } else if (index >= 12 && index <= 20) {
            if (this.getCarried().isEmpty()) {
                ((TrashCanBlockEntity)((Object)this.object)).liquidFilter.set(index - 12, null);
            } else {
                ItemFilter filter = LiquidTrashCanFilters.createFilter(this.getCarried());
                if (filter != null) {
                    ((TrashCanBlockEntity)((Object)this.object)).liquidFilter.set(index - 12, filter);
                }
            }
            ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
        } else if (index >= 21 && !this.getSlot(index).getItem().isEmpty()) {
            ItemStack stack = this.getSlot(index).getItem();
            if (this.getSlot(1).getItem().isEmpty() && this.getSlot(1).mayPlace(stack)) {
                this.getSlot(1).set(stack);
                this.getSlot(index).set(ItemStack.EMPTY);
                ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
            } else if (this.getSlot(2).getItem().isEmpty() && this.getSlot(2).mayPlace(stack)) {
                this.getSlot(2).set(stack);
                this.getSlot(index).set(ItemStack.EMPTY);
                ((TrashCanBlockEntity)((Object)this.object)).dataChanged();
            } else if (this.getSlot(0).mayPlace(stack)) {
                this.getSlot(index).set(ItemStack.EMPTY);
            }
        }
        return ItemStack.EMPTY;
    }

    private IItemHandlerModifiable liquidFilterHandler() {
        return new ItemStackHandler(9){

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                TrashCanBlockEntity entity = (TrashCanBlockEntity)((Object)UltimateTrashCanContainer.this.object);
                return entity == null || entity.liquidFilter.get(slot) == null ? ItemStack.EMPTY : entity.liquidFilter.get(slot).getRepresentingItem();
            }
        };
    }

    private IItemHandlerModifiable itemFilterHandler() {
        return new ItemStackHandler(9){

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return UltimateTrashCanContainer.this.validateObjectOrClose() ? ((TrashCanBlockEntity)((Object)((UltimateTrashCanContainer)UltimateTrashCanContainer.this).object)).itemFilter.get(slot) : ItemStack.EMPTY;
            }
        };
    }
}

