/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;
import org.cyclops.integrateddynamics.core.network.event.NetworkInitializedEvent;

public class NetworkInitializedTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(Instance::player), (App)ExtraCodecs.strictOptionalField((Codec)Codec.INT, (String)"min_cables").forGetter(Instance::minCables)).apply((Applicative)p_311401_, Instance::new));

    public NetworkInitializedTrigger() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public Codec<Instance> codec() {
        return CODEC;
    }

    public void test(ServerPlayer player, NetworkInitializedEvent event) {
        this.trigger(player, instance -> instance.test(player, event));
    }

    @SubscribeEvent
    public void onCrafted(NetworkInitializedEvent event) {
        if (event.getPlacer() != null && event.getPlacer() instanceof ServerPlayer) {
            this.test((ServerPlayer)event.getPlacer(), event);
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, Optional<Integer> minCables) implements SimpleCriterionTrigger.SimpleInstance,
    ICriterionInstanceTestable<NetworkInitializedEvent>
    {
        public boolean test(ServerPlayer player, NetworkInitializedEvent networkEvent) {
            return this.minCables.map(minCablesCount -> networkEvent.getNetwork().getCablesCount() >= minCablesCount).orElse(true);
        }
    }
}

