/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class PartPos
implements Comparable<PartPos> {
    private final DimPos pos;
    private final Direction side;

    public static PartPos of(Level world, BlockPos pos, @Nullable Direction side) {
        return PartPos.of(DimPos.of((Level)world, (BlockPos)pos), side);
    }

    public static PartPos of(DimPos pos, @Nullable Direction side) {
        return new PartPos(pos, side);
    }

    private PartPos(DimPos pos, @Nullable Direction side) {
        this.pos = pos;
        this.side = side;
    }

    public DimPos getPos() {
        return this.pos;
    }

    @Nullable
    public Direction getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PartPos)) {
            return false;
        }
        PartPos partPos = (PartPos)o;
        if (!this.pos.equals((Object)partPos.pos)) {
            return false;
        }
        return this.side == partPos.side;
    }

    public int hashCode() {
        return 31 * this.pos.hashCode() + (this.side != null ? this.side.hashCode() : 0);
    }

    public String toString() {
        return "PartPos{pos=" + this.pos + ", side=" + this.side + "}";
    }

    @Nullable
    public static Pair<IPartType, IPartState> getPartData(PartPos pos) {
        IPartContainer partContainer = PartHelpers.getPartContainer(pos.getPos(), pos.getSide()).orElse(null);
        if (partContainer != null) {
            IPartType partType = partContainer.getPart(pos.getSide());
            IPartState partState = partContainer.getPartState(pos.getSide());
            if (partType != null && partState != null) {
                return Pair.of((Object)partType, (Object)partState);
            }
        }
        return null;
    }

    @Override
    public int compareTo(PartPos o) {
        int pos = this.getPos().compareTo(o.getPos());
        if (pos == 0) {
            Direction thisSide = this.getSide();
            Direction thatSide = o.getSide();
            return thisSide == null ? (thatSide == null ? 0 : -1) : (thatSide == null ? 1 : thisSide.compareTo((Enum)thatSide));
        }
        return pos;
    }

    static {
        PacketCodec.addCodedAction(PartPos.class, (PacketCodec.ICodecAction)new PacketCodec.ICodecAction(){

            public void encode(Object object, FriendlyByteBuf packetBuffer) {
                PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)((PartPos)object).getPos());
                PacketCodec.write((FriendlyByteBuf)packetBuffer, (Object)((PartPos)object).getSide());
            }

            public Object decode(FriendlyByteBuf packetBuffer) {
                DimPos pos = (DimPos)PacketCodec.read((FriendlyByteBuf)packetBuffer, DimPos.class);
                Direction side = (Direction)PacketCodec.read((FriendlyByteBuf)packetBuffer, Direction.class);
                return PartPos.of(pos, side);
            }
        });
    }
}

