/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IDynamicLight;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.block.BlockCableConfig;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableCenter;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerCableConnections;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerFacade;
import org.cyclops.integrateddynamics.block.shapes.VoxelShapeComponentsFactoryHandlerParts;
import org.cyclops.integrateddynamics.client.model.CableModel;
import org.cyclops.integrateddynamics.client.model.IRenderState;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class BlockCable
extends BlockWithEntity
implements IDynamicModelElement,
SimpleWaterloggedBlock {
    public static final MapCodec<BlockCable> CODEC = BlockCable.simpleCodec(BlockCable::new);
    public static final float BLOCK_HARDNESS = 3.0f;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final ModelProperty<Boolean> REALCABLE = new ModelProperty();
    public static final ModelProperty<Boolean>[] CONNECTED = new ModelProperty[6];
    public static final ModelProperty<PartRenderPosition>[] PART_RENDERPOSITIONS = new ModelProperty[6];
    public static final ModelProperty<Optional<BlockState>> FACADE = new ModelProperty();
    public static final ModelProperty<IPartContainer> PARTCONTAINER;
    public static final ModelProperty<IRenderState> RENDERSTATE;
    public static final AABB CABLE_CENTER_BOUNDINGBOX;
    private static final EnumFacingMap<AABB> CABLE_SIDE_BOUNDINGBOXES;
    private final VoxelShapeComponentsFactory voxelShapeComponentsFactory = new VoxelShapeComponentsFactory(new VoxelShapeComponentsFactoryHandlerCableCenter(), new VoxelShapeComponentsFactoryHandlerCableConnections(), new VoxelShapeComponentsFactoryHandlerParts(), new VoxelShapeComponentsFactoryHandlerFacade());
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite texture;
    private boolean disableCollisionBox = false;
    private final Cache<String, VoxelShape> CACHE_COLLISION_SHAPES = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public BlockCable(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityMultipartTicking::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getModEventBus().addListener(this::postTextureStitch);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            this.texture = event.getAtlas().getSprite(new ResourceLocation("integrateddynamics", "block/cable"));
        }
    }

    public boolean useShapeForLightOcclusion(BlockState p_60576_) {
        return true;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockCable.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MULTIPART_TICKING.get()), new BlockEntityMultipartTicking.Ticker());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        NetworkHelpers.onElementProviderBlockNeighborChange((Level)worldIn, currentPos, facingState.getBlock(), facing, facingPos);
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean canPlaceLiquid(@org.jetbrains.annotations.Nullable Player player, BlockGetter worldIn, BlockPos pos, BlockState blockState, Fluid fluidIn) {
        ILevelExtension levelExtension;
        return (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) == false && fluidIn == Fluids.WATER && (!(worldIn instanceof ILevelExtension) || !CableHelpers.hasFacade(levelExtension = (ILevelExtension)worldIn, pos));
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos blockPos, Explosion explosion) {
        CableHelpers.setRemovingCable(true);
        CableHelpers.onCableRemoving(world, blockPos, true, false);
        Collection<Direction> connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
        super.onBlockExploded(state, world, blockPos, explosion);
        CableHelpers.onCableRemoved(world, blockPos, connectedCables);
        CableHelpers.setRemovingCable(false);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, (BlockGetter)world, pos, CollisionContext.of((Entity)player)).rayTrace(pos, (Entity)player);
        if (rayTraceResult != null && rayTraceResult.getComponent().destroy(world, pos, player, false)) {
            return false;
        }
        return rayTraceResult != null && super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void onRemove(BlockState state, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (newState.getBlock() != this) {
            Collection<Direction> connectedCables = null;
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoving(world, blockPos, false, false);
                connectedCables = CableHelpers.getExternallyConnectedCables(world, blockPos);
            }
            super.onRemove(state, world, blockPos, newState, isMoving);
            if (!CableHelpers.isRemovingCable()) {
                CableHelpers.onCableRemoved(world, blockPos, connectedCables);
            }
        } else {
            super.onRemove(state, world, blockPos, newState, isMoving);
        }
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult actionResultType;
        BlockRayTraceResultComponent rayTraceResult;
        BlockEntityMultipartTicking tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityMultipartTicking.class).orElse(null);
        if (tile != null && (rayTraceResult = this.getSelectedShape(state, (BlockGetter)world, pos, CollisionContext.of((Entity)player)).rayTrace(pos, (Entity)player)) != null && (actionResultType = rayTraceResult.getComponent().onBlockActivated(state, world, pos, player, hand, rayTraceResult)).consumesAction()) {
            return actionResultType;
        }
        return super.use(state, world, pos, player, hand, hit);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!world.isClientSide() && !state.hasBlockEntity()) {
            CableHelpers.onCableAdded(world, pos);
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide()) {
            CableHelpers.onCableAddedByPlayer(world, pos, placer);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos blockPos, Player player) {
        BlockRayTraceResultComponent rayTraceResult = this.getSelectedShape(state, (BlockGetter)world, blockPos, CollisionContext.of((Entity)player)).rayTrace(blockPos, (Entity)player);
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getCloneItemStack((Level)world, blockPos);
        }
        return this.getCloneItemStack(world, blockPos, state);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, isMoving);
        NetworkHelpers.onElementProviderBlockNeighborChange(world, pos, neighborBlock, null, fromPos);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
        if (world instanceof Level) {
            Level level = (Level)world;
            NetworkHelpers.onElementProviderBlockNeighborChange(level, pos, world.getBlockState(neighbor).getBlock(), null, neighbor);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        super.tick(state, world, pos, rand);
        BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityMultipartTicking.class).ifPresent(tile -> {
            for (Map.Entry entry : tile.getPartContainer().getPartData().entrySet()) {
                this.updateTickPart(((PartHelpers.PartStateHolder)entry.getValue()).getPart(), (Level)world, pos, (IPartState)((PartHelpers.PartStateHolder)entry.getValue()).getState(), rand);
            }
        });
    }

    protected void updateTickPart(IPartType partType, Level world, BlockPos pos, IPartState partState, RandomSource random) {
        partType.updateTick(world, pos, partState, random);
    }

    public AABB getCableBoundingBox(Direction side) {
        if (side == null) {
            return CABLE_CENTER_BOUNDINGBOX;
        }
        return (AABB)CABLE_SIDE_BOUNDINGBOXES.get((Object)side);
    }

    public VoxelShapeComponents getSelectedShape(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.voxelShapeComponentsFactory.createShape(blockState, world, pos, selectionContext);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        VoxelShapeComponents selectedShape = this.getSelectedShape(state, world, pos, selectionContext);
        BlockRayTraceResultComponent rayTraceResult = selectedShape.rayTrace(pos, selectionContext instanceof EntityCollisionContext ? ((EntityCollisionContext)selectionContext).getEntity() : null);
        if (rayTraceResult != null) {
            return rayTraceResult.getComponent().getShape(state, world, pos, selectionContext);
        }
        return selectedShape;
    }

    public VoxelShape getCollisionShape(BlockState blockState, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        if (this.disableCollisionBox) {
            return Shapes.empty();
        }
        VoxelShapeComponents voxelShapeComponents = (VoxelShapeComponents)super.getCollisionShape(blockState, world, pos, selectionContext);
        String cableState = voxelShapeComponents.getStateId();
        return (VoxelShape)this.CACHE_COLLISION_SHAPES.get((Object)cableState, () -> {
            Iterator<VoxelShape> it = voxelShapeComponents.iterator();
            if (!it.hasNext()) {
                return Shapes.empty();
            }
            VoxelShape shape = it.next();
            while (it.hasNext()) {
                shape = Shapes.join((VoxelShape)shape, (VoxelShape)it.next(), (BooleanOp)BooleanOp.OR);
            }
            return shape.optimize();
        });
    }

    public boolean hasDynamicShape() {
        return BlockCableConfig.dynamicShape;
    }

    public int getLightBlock(BlockState blockState, BlockGetter world, BlockPos pos) {
        if (world instanceof Level) {
            Level level = (Level)world;
            if (CableHelpers.isLightTransparent(level, pos, null)) {
                return 0;
            }
            return CableHelpers.getFacade((ILevelExtension)level, pos).map(facade -> facade.getLightBlock(world, pos)).orElse(0);
        }
        return 0;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(){

            public boolean addHitEffects(BlockState blockState, Level world, HitResult target, ParticleEngine particleManager) {
                BlockPos blockPos = ((BlockHitResult)target).getBlockPos();
                if (CableHelpers.hasFacade((ILevelExtension)world, blockPos)) {
                    CableHelpers.getFacade((ILevelExtension)world, blockPos).ifPresent(facadeState -> RenderHelpers.addBlockHitEffects((ParticleEngine)particleManager, (ClientLevel)((ClientLevel)world), (BlockState)facadeState, (BlockPos)blockPos, (Direction)((BlockHitResult)target).getDirection()));
                    return true;
                }
                return false;
            }
        });
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        ILevelExtension levelExtension;
        return world instanceof ILevelExtension && CableHelpers.getFacade(levelExtension = (ILevelExtension)world, pos).isPresent();
    }

    public boolean isSignalSource(BlockState blockState) {
        return true;
    }

    public boolean canConnectRedstone(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (side == null) {
            for (Direction dummySide : Direction.values()) {
                IDynamicRedstone dynamicRedstone = BlockEntityHelpers.getCapability((ILevelExtension)((ILevelExtension)world), (BlockPos)pos, (Object)dummySide, Capabilities.DynamicRedstone.BLOCK).orElse(null);
                if (dynamicRedstone == null || dynamicRedstone.getRedstoneLevel() < 0 && !dynamicRedstone.isAllowRedstoneInput()) continue;
                return true;
            }
            return false;
        }
        IDynamicRedstone dynamicRedstone = BlockEntityHelpers.getCapability((ILevelExtension)((ILevelExtension)world), (BlockPos)pos, (Object)side.getOpposite(), Capabilities.DynamicRedstone.BLOCK).orElse(null);
        return dynamicRedstone != null && (dynamicRedstone.getRedstoneLevel() >= 0 || dynamicRedstone.isAllowRedstoneInput());
    }

    public int getDirectSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = BlockEntityHelpers.getCapability((ILevelExtension)((ILevelExtension)world), (BlockPos)pos, (Object)side.getOpposite(), Capabilities.DynamicRedstone.BLOCK).orElse(null);
        return dynamicRedstone != null && dynamicRedstone.isDirect() ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int getSignal(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        IDynamicRedstone dynamicRedstone = BlockEntityHelpers.getCapability((ILevelExtension)((ILevelExtension)world), (BlockPos)pos, (Object)side.getOpposite(), Capabilities.DynamicRedstone.BLOCK).orElse(null);
        return dynamicRedstone != null ? dynamicRedstone.getRedstoneLevel() : 0;
    }

    public int getLightEmission(BlockState blockState, BlockGetter world, BlockPos pos) {
        int light = 0;
        if (world instanceof ILevelExtension) {
            ILevelExtension levelExtension = (ILevelExtension)world;
            for (Direction side : Direction.values()) {
                IDynamicLight dynamicLight = BlockEntityHelpers.getCapability((ILevelExtension)levelExtension, (BlockPos)pos, (Object)side, Capabilities.DynamicLight.BLOCK).orElse(null);
                if (dynamicLight == null) continue;
                light = Math.max(light, dynamicLight.getLightLevel());
            }
        }
        return light;
    }

    public boolean hasDynamicModel() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BakedModel createDynamicModel(ModelEvent.ModifyBakingResult event) {
        CableModel model = new CableModel();
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)this);
        event.getModels().put(new ModelResourceLocation(registryName, "waterlogged=false"), model);
        event.getModels().put(new ModelResourceLocation(registryName, "waterlogged=true"), model);
        event.getModels().put(new ModelResourceLocation(registryName, "inventory"), model);
        return model;
    }

    public void setDisableCollisionBox(boolean disableCollisionBox) {
        this.disableCollisionBox = disableCollisionBox;
    }

    static {
        for (Direction side : Direction.values()) {
            BlockCable.CONNECTED[side.ordinal()] = new ModelProperty();
            BlockCable.PART_RENDERPOSITIONS[side.ordinal()] = new ModelProperty();
        }
        PARTCONTAINER = new ModelProperty();
        RENDERSTATE = new ModelProperty();
        CABLE_CENTER_BOUNDINGBOX = new AABB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
        CABLE_SIDE_BOUNDINGBOXES = EnumFacingMap.forAllValues((Object)new AABB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), (Object)new AABB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), (Object)new AABB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), (Object)new AABB(0.375, 0.625, 0.625, 0.625, 0.375, 1.0), (Object)new AABB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), (Object)new AABB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BlockColor
    implements net.minecraft.client.color.block.BlockColor {
        public int getColor(BlockState blockState, @Nullable BlockAndTintGetter world, @Nullable BlockPos blockPos, int color) {
            return world == null || blockPos == null ? -1 : CableHelpers.getFacade((ILevelExtension)world, blockPos).map(facadeState -> Minecraft.getInstance().getBlockColors().getColor(facadeState, world, blockPos, color)).orElse(-1);
        }
    }
}

