/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;

public class BlockDryingBasin
extends BlockWithEntityGui {
    public static final MapCodec<BlockDryingBasin> CODEC = BlockDryingBasin.simpleCodec(BlockDryingBasin::new);
    private static final VoxelShape SHAPE_RAYTRACE = BlockDryingBasin.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)BlockDryingBasin.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BlockDryingBasin.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BlockDryingBasin.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), SHAPE_RAYTRACE}), (BooleanOp)BooleanOp.ONLY_FIRST);

    public BlockDryingBasin(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityDryingBasin::new);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return BlockDryingBasin.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DRYING_BASIN.get()), (BlockEntityTicker)(level.isClientSide ? new BlockEntityDryingBasin.TickerClient() : new BlockEntityDryingBasin.TickerServer()));
    }

    public InteractionResult use(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).map(tile -> {
            ItemStack itemStack = player.getInventory().getSelected();
            IFluidHandler itemFluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            SingleUseTank tank = tile.getTank();
            ItemStack tileStack = tile.getInventory().getItem(0);
            if (itemStack.isEmpty() && !tileStack.isEmpty()) {
                player.getInventory().setItem(player.getInventory().selected, tileStack);
                tile.getInventory().setItem(0, ItemStack.EMPTY);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (player.getInventory().add(tileStack)) {
                tile.getInventory().setItem(0, ItemStack.EMPTY);
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isFull() && !itemFluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                FluidActionResult fluidAction = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (fluidAction.isSuccess()) {
                    ItemStack newItemStack = fluidAction.getResult();
                    InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                    tile.sendUpdate();
                }
                return InteractionResult.SUCCESS;
            }
            if (itemFluidHandler != null && !tank.isEmpty() && itemFluidHandler.fill(tank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                FluidActionResult fluidAction = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (fluidAction.isSuccess()) {
                    ItemStack newItemStack = fluidAction.getResult();
                    InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)newItemStack);
                }
                return InteractionResult.SUCCESS;
            }
            if (!itemStack.isEmpty() && tileStack.isEmpty()) {
                tile.getInventory().setItem(0, itemStack.split(1));
                if (itemStack.getCount() <= 0) {
                    player.getInventory().setItem(player.getInventory().selected, ItemStack.EMPTY);
                }
                tile.sendUpdate();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos blockPos) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).map(tile -> tile.getInventory().getItem(0) != null ? 15 : 0).orElse(0);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        return SHAPE_RAYTRACE;
    }

    public void onRemove(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.getBlock() != newState.getBlock()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityDryingBasin.class).ifPresent(tile -> {
                InventoryHelpers.dropItems((Level)world, (Container)tile.getInventory(), (BlockPos)blockPos);
                world.updateNeighbourForOutputSignal(blockPos, oldState.getBlock());
            });
            super.onRemove(oldState, world, blockPos, newState, isMoving);
        }
    }
}

