/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.TextureAtlasStitchedEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;

public class BlockEnergyBattery
extends BlockEnergyBatteryBase {
    public static final MapCodec<BlockEnergyBattery> CODEC = BlockEnergyBattery.simpleCodec(BlockEnergyBattery::new);
    public TextureAtlasSprite iconOverlay;

    public BlockEnergyBattery(BlockBehaviour.Properties properties) {
        super(properties);
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getModEventBus().addListener(this::postTextureStitch);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureAtlasStitchedEvent event) {
        if (event.getAtlas().location().equals((Object)InventoryMenu.BLOCK_ATLAS)) {
            this.iconOverlay = event.getAtlas().getSprite(new ResourceLocation("integrateddynamics", "block/energy_battery_overlay"));
        }
    }

    @Override
    public boolean isCreative() {
        return false;
    }
}

