/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.core.block.BlockContainerCabled;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public abstract class BlockEnergyBatteryBase
extends BlockContainerCabled
implements IEnergyContainerBlock {
    public BlockEnergyBatteryBase(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEnergyBattery::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : BlockEnergyBatteryBase.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_ENERGY_BATTERY.get()), (BlockEntityTicker)new BlockEntityEnergyBattery.Ticker());
    }

    @Override
    public String getEneryContainerNBTName() {
        return "energy";
    }

    @Override
    public String getEneryContainerCapacityNBTName() {
        return "capacity";
    }

    public abstract boolean isCreative();

    @Override
    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        InteractionResult superActionResult = super.use(state, world, pos, player, hand, blockRayTraceResult);
        if (superActionResult.consumesAction()) {
            return superActionResult;
        }
        if (player.getItemInHand(hand).isEmpty()) {
            return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityEnergyBattery.class).map(tile -> {
                player.displayClientMessage(Helpers.getLocalizedEnergyLevel(tile.getEnergyStored(), tile.getMaxEnergyStored()), true);
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public static void fill(IEnergyStorage energyStorage) {
        int max = energyStorage.getMaxEnergyStored();
        int stored = 1;
        while (stored > 0) {
            stored = energyStorage.receiveEnergy(max, false);
        }
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockPos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.isClientSide()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityEnergyBattery.class).ifPresent(tile -> BlockEnergyBatteryBase.itemStackToTile(itemStack.copy().split(1), tile));
        }
        super.setPlacedBy(world, blockPos, state, placer, itemStack);
    }

    public static void itemStackToTile(ItemStack itemStack, BlockEntityEnergyBattery tile) {
        Optional.ofNullable((IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM)).ifPresent(energyStorage -> {
            tile.setEnergyStored(energyStorage.getEnergyStored());
            tile.setCapacity(energyStorage.getMaxEnergyStored());
        });
    }
}

