/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block.shapes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponents;
import org.cyclops.integrateddynamics.core.block.VoxelShapeComponentsFactory;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class VoxelShapeComponentsFactoryHandlerParts
implements VoxelShapeComponentsFactory.IHandler {
    @Override
    public Collection<VoxelShapeComponents.IComponent> createComponents(BlockState blockState, BlockGetter world, BlockPos blockPos) {
        ArrayList components = Lists.newArrayList();
        if (world instanceof ILevelExtension) {
            ILevelExtension level = (ILevelExtension)world;
            for (Direction direction : Direction.values()) {
                IPartContainer partContainer = PartHelpers.getPartContainer(level, blockPos, direction).orElse(null);
                if (partContainer == null || !partContainer.hasPart(direction)) continue;
                components.add(new Component(direction, partContainer));
            }
        }
        return components;
    }

    public static class Component
    implements VoxelShapeComponents.IComponent {
        private final Direction direction;
        private final IPartContainer partContainer;

        public Component(Direction direction, IPartContainer partContainer) {
            this.direction = direction;
            this.partContainer = partContainer;
        }

        public Optional<IPartType> getPart() {
            return Optional.ofNullable(this.partContainer.getPart(this.direction));
        }

        @Override
        public String getStateId(BlockState blockState, BlockGetter world, BlockPos blockPos) {
            return this.getPart().map(part -> "part(" + part.getPartRenderPosition().toCompactString() + ")").orElse("part");
        }

        @Override
        public VoxelShape getShape(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext) {
            return this.getPart().map(part -> part.getPartRenderPosition().getBoundingBox(this.direction)).orElse(Shapes.empty());
        }

        @Override
        public ItemStack getCloneItemStack(Level world, BlockPos pos) {
            return this.getPart().map(part -> part.getCloneItemStack(world, pos, this.partContainer.getPartState(this.direction))).orElse(ItemStack.EMPTY);
        }

        @Override
        public boolean destroy(Level world, BlockPos pos, Player player, boolean saveState) {
            if (!world.isClientSide()) {
                return PartHelpers.removePart(world, pos, this.direction, player, true, true, saveState);
            }
            return false;
        }

        @Override
        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public BakedModel getBreakingBaseModel(Level world, BlockPos pos) {
            return RenderHelpers.getBakedModel((BlockState)this.getPart().map(part -> part.getBlockState(this.partContainer, this.direction)).orElse(null));
        }

        @Override
        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockRayTraceResultComponent hit) {
            ItemStack heldItem = player.getItemInHand(hand);
            if (WrenchHelpers.isWrench(player, heldItem, world, blockPos, hit.getDirection()) && player.isSecondaryUseActive()) {
                if (!world.isClientSide()) {
                    this.destroy(world, blockPos, player, true);
                    ItemBlockCable.playBreakSound(world, blockPos, state);
                }
                return InteractionResult.SUCCESS;
            }
            if (CableHelpers.isNoFakeCable((ILevelExtension)world, blockPos, hit.getDirection())) {
                return this.getPart().map(part -> part.onPartActivated(this.partContainer.getPartState(this.direction), blockPos, world, player, hand, heldItem, hit.withDirection(this.direction))).orElse(InteractionResult.FAIL);
            }
            return InteractionResult.PASS;
        }

        @Override
        @Nullable
        public Direction getRaytraceDirection() {
            return this.direction;
        }

        @Override
        public boolean isRaytraceLastForFace() {
            return false;
        }
    }
}

