/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IValueTypeVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityActiveVariableBase;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.item.ValueTypeVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerMaterializer;
import org.cyclops.integrateddynamics.network.MaterializerNetworkElement;

public class BlockEntityMaterializer
extends BlockEntityActiveVariableBase<MaterializerNetworkElement>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    private Player lastPlayer = null;
    private boolean writeVariable;

    public BlockEntityMaterializer(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MATERIALIZER.get(), blockPos, blockState, 3);
    }

    @Override
    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new MaterializerNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        };
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                return slot != 2 && super.canPlaceItem(slot, itemStack);
            }
        };
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected boolean canWrite() {
        return NetworkHelpers.getPartNetwork(this.getNetwork()).map(partNetwork -> this.getVariable((IPartNetwork)partNetwork) != null && this.getEvaluator().getErrors().isEmpty()).orElse(false);
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.level.isClientSide()) {
            this.writeVariable = true;
        }
    }

    public ItemStack writeMaterialized(boolean generateId, ItemStack itemStack) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        IVariable<?> variable = this.getVariable(NetworkHelpers.getPartNetworkChecked(this.getNetwork()));
        try {
            final Object value = variable.getType().materialize(variable.getValue());
            final IValueType valueType = value.getType();
            return registry.writeVariableFacadeItem(generateId, itemStack, ValueTypes.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IValueTypeVariableFacade>(){

                @Override
                public IValueTypeVariableFacade create(boolean generateId) {
                    return new ValueTypeVariableFacade<IValue>(generateId, valueType, value);
                }

                @Override
                public IValueTypeVariableFacade create(int id) {
                    return new ValueTypeVariableFacade<IValue>(id, valueType, value);
                }
            }, this.getLevel(), this.lastPlayer, this.getBlockState());
        }
        catch (EvaluationException e) {
            this.getEvaluator().addError(Component.translatable((String)e.getMessage()));
            return ItemStack.EMPTY;
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMaterializer(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integrateddynamics.materializer");
    }

    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityMaterializer> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityMaterializer blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            if (blockEntity.writeVariable && !blockEntity.getInventory().getItem(1).isEmpty() && blockEntity.canWrite() && blockEntity.getInventory().getItem(2).isEmpty()) {
                blockEntity.writeVariable = false;
                ItemStack outputStack = blockEntity.writeMaterialized(!blockEntity.getLevel().isClientSide, blockEntity.getInventory().getItem(1));
                if (!outputStack.isEmpty()) {
                    blockEntity.getInventory().setItem(2, outputStack);
                    blockEntity.getInventory().removeItemNoUpdate(1);
                }
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCableConnectableInventory.CapabilityRegistrar<BlockEntityMaterializer> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityMaterializer>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int slot = -1;
                switch (direction) {
                    case DOWN: {
                        slot = 2;
                        break;
                    }
                    case UP: {
                        slot = 1;
                        break;
                    }
                    case NORTH: {
                        slot = 0;
                        break;
                    }
                    case SOUTH: {
                        slot = 0;
                        break;
                    }
                    case WEST: {
                        slot = 0;
                        break;
                    }
                    case EAST: {
                        slot = 0;
                    }
                }
                return new ItemHandlerSlotMasked((Container)blockEntity.getInventory(), new int[]{slot});
            });
            this.add(Capabilities.NetworkElementProvider.BLOCK, (blockEntity, direction) -> blockEntity.getNetworkElementProvider());
        }
    }
}

