/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalDryingBasin;

public class BlockEntityMechanicalDryingBasin
extends BlockEntityMechanicalMachine<Pair<ItemStack, FluidStack>, RecipeMechanicalDryingBasin>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private final SingleUseTank tankIn = new SingleUseTank(10000);
    private final SingleUseTank tankOut = new SingleUseTank(100000);

    public BlockEntityMechanicalDryingBasin(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MECHANICAL_DRYING_BASIN.get(), blockPos, blockState, 5);
        this.tankIn.addDirtyMarkListener(this::onTankChanged);
        this.tankOut.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeHolder<RecipeMechanicalDryingBasin>>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeHolder<RecipeMechanicalDryingBasin>>>(){

            public Optional<RecipeHolder<RecipeMechanicalDryingBasin>> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.of((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(BlockEntityMechanicalDryingBasin.this.getRecipeRegistry(), (Container)recipeInput, (Level)BlockEntityMechanicalDryingBasin.this.getLevel());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.matches((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.getLevel().getBlockState(this.getBlockPos()).getValue((Property)BlockMechanicalDryingBasin.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getLevel().getBlockState(this.getBlockPos()).setValue((Property)BlockMechanicalDryingBasin.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTankInput() {
        return this.tankIn;
    }

    public SingleUseTank getTankOutput() {
        return this.tankOut;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        this.getTankInput().readFromNBT(tag.getCompound("tankIn"));
        this.getTankOutput().readFromNBT(tag.getCompound("tankOut"));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.put("tankIn", (Tag)this.getTankInput().writeToNBT(new CompoundTag()));
        tag.put("tankOut", (Tag)this.getTankOutput().writeToNBT(new CompoundTag()));
        super.saveAdditional(tag);
    }

    @Override
    protected RecipeType<RecipeMechanicalDryingBasin> getRecipeRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get();
    }

    @Override
    protected Pair<ItemStack, FluidStack> getCurrentRecipeCacheKey() {
        return Pair.of((Object)this.getInventory().getItem(0).copy(), (Object)FluidHelpers.copy((FluidStack)this.getTankInput().getFluid()));
    }

    @Override
    public int getRecipeDuration(RecipeHolder<RecipeMechanicalDryingBasin> recipe) {
        return ((RecipeMechanicalDryingBasin)recipe.value()).getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalDryingBasin recipe, boolean simulate) {
        Optional<FluidStack> inputFluid;
        IFluidHandler.FluidAction fluidAction = FluidHelpers.simulateBooleanToAction((boolean)simulate);
        ItemStack outputStack = recipe.getOutputItemFirst().copy();
        if (!outputStack.isEmpty() && !InventoryHelpers.addToInventory((Container)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)NonNullList.withSize((int)1, (Object)outputStack), (boolean)simulate).isEmpty()) {
            return false;
        }
        Optional<FluidStack> outputFluid = recipe.getOutputFluid();
        if (outputFluid.isPresent() && this.getTankOutput().fill(outputFluid.get().copy(), fluidAction) != outputFluid.get().getAmount()) {
            return false;
        }
        if (!simulate && !recipe.getInputIngredient().isEmpty()) {
            this.getInventory().removeItem(0, 1);
        }
        return !(inputFluid = recipe.getInputFluid()).isPresent() || FluidHelpers.getAmount((FluidStack)this.getTankInput().drain(inputFluid.get(), fluidAction)) == inputFluid.get().getAmount();
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalDryingBasinConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalDryingBasinConfig.capacity;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMechanicalDryingBasin(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integrateddynamics.mechanical_drying_basin");
    }

    public static class CapabilityRegistrar
    extends BlockEntityMechanicalMachine.CapabilityRegistrar<BlockEntityMechanicalDryingBasin> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityMechanicalDryingBasin>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> direction == Direction.DOWN ? blockEntity.getTankOutput() : blockEntity.getTankInput());
            this.add(Capabilities.RecipeHandler.BLOCK, (blockEntity, direction) -> new RecipeHandlerDryingBasin(() -> ((BlockEntityMechanicalDryingBasin)((Object)blockEntity)).getLevel(), (RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get()));
        }
    }
}

