/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityActiveVariableBase;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.ProxyVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ProxyVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerProxy;
import org.cyclops.integrateddynamics.network.ProxyNetworkElement;

public class BlockEntityProxy
extends BlockEntityActiveVariableBase<ProxyNetworkElement>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    public static final String GLOBALCOUNTER_KEY = "proxy";
    @NBTPersist
    private int proxyId = -1;
    private Player lastPlayer = null;
    private boolean writeVariable;

    public BlockEntityProxy(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RegistryEntries.BLOCK_ENTITY_PROXY.get(), blockPos, blockState, 3);
    }

    public BlockEntityProxy(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState, inventorySize);
    }

    @Override
    public INetworkElementProvider getNetworkElementProvider() {
        return new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new ProxyNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        };
    }

    public boolean isWriteVariable() {
        return this.writeVariable;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean canPlaceItem(int slot, ItemStack itemStack) {
                return slot != 2 && super.canPlaceItem(slot, itemStack);
            }
        };
    }

    @Override
    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((Container)this.getInventory(), this.getSlotRead(), ValueDeseralizationContext.of(this.getLevel()), (IValueType)ValueTypes.CATEGORY_ANY){

            @Override
            protected void preValidate() {
                super.preValidate();
                if (this.getVariableFacade() instanceof IProxyVariableFacade && ((IProxyVariableFacade)this.getVariableFacade()).getProxyId() == BlockEntityProxy.this.getProxyId()) {
                    this.addError(Component.translatable((String)"variable.integrateddynamics.error.recursion", (Object[])new Object[]{this.getVariableFacade().getId()}));
                }
            }
        };
    }

    public void generateNewProxyId() {
        this.proxyId = IntegratedDynamics.globalCounters.getNext(GLOBALCOUNTER_KEY);
        this.setChanged();
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected int getSlotWriteIn() {
        return 1;
    }

    protected int getSlotWriteOut() {
        return 2;
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.level.isClientSide()) {
            this.writeVariable = true;
        }
    }

    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, ProxyVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IProxyVariableFacade>(){

            @Override
            public IProxyVariableFacade create(boolean generateId) {
                return new ProxyVariableFacade(generateId, proxyId);
            }

            @Override
            public IProxyVariableFacade create(int id) {
                return new ProxyVariableFacade(id, proxyId);
            }
        }, this.getLevel(), this.lastPlayer, this.getBlockState());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerProxy(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.integrateddynamics.proxy");
    }

    public int getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(int proxyId) {
        this.proxyId = proxyId;
    }

    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public static class Ticker<T extends BlockEntityProxy>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityProxy)blockEntity).isWriteVariable() && !((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().getItem(((BlockEntityProxy)blockEntity).getSlotWriteIn()).isEmpty() && ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().getItem(((BlockEntityProxy)blockEntity).getSlotWriteOut()).isEmpty()) {
                ItemStack outputStack = ((BlockEntityProxy)blockEntity).writeProxyInfo(!blockEntity.getLevel().isClientSide, ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().removeItemNoUpdate(((BlockEntityProxy)blockEntity).getSlotWriteIn()), ((BlockEntityProxy)blockEntity).getProxyId());
                ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().setItem(((BlockEntityProxy)blockEntity).getSlotWriteOut(), outputStack);
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityActiveVariableBase.CapabilityRegistrar<BlockEntityProxy> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityProxy>> blockEntityType) {
            super(blockEntityType);
        }

        @Override
        public void populate() {
            super.populate();
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> {
                int slot = -1;
                switch (direction) {
                    case DOWN: {
                        slot = 2;
                        break;
                    }
                    case UP: {
                        slot = 1;
                        break;
                    }
                    case NORTH: {
                        slot = 0;
                        break;
                    }
                    case SOUTH: {
                        slot = 0;
                        break;
                    }
                    case WEST: {
                        slot = 0;
                        break;
                    }
                    case EAST: {
                        slot = 0;
                    }
                }
                return new ItemHandlerSlotMasked((Container)blockEntity.getInventory(), new int[]{slot});
            });
            this.add(Capabilities.NetworkElementProvider.BLOCK, (blockEntity, direction) -> blockEntity.getNetworkElementProvider());
        }
    }
}

