/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.energystorage;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class EnergyStorageItemBlockEnergyContainer
implements IEnergyStorageCapacity,
IEnergyStorageMutable {
    private final ItemBlockEnergyContainer itemBlockEnergyContainer;
    private final ItemStack itemStack;
    private final int rate;

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack, int rate) {
        this.itemBlockEnergyContainer = itemBlockEnergyContainer;
        this.itemStack = itemStack;
        this.rate = rate;
        if (!this.itemStack.hasTag()) {
            this.setItemStackEnergy(itemStack, 0);
        }
    }

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack) {
        this(itemBlockEnergyContainer, itemStack, Integer.MAX_VALUE);
    }

    public int getRate() {
        return this.rate;
    }

    public boolean isCreative() {
        IEnergyContainerBlock block = this.itemBlockEnergyContainer.get();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    protected int getEnergyStoredSingular() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        CompoundTag tag = this.itemStack.getOrCreateTag();
        return tag.getInt(this.itemBlockEnergyContainer.get().getEneryContainerNBTName());
    }

    public int getEnergyStored() {
        return Helpers.multiplySafe((int)this.getEnergyStoredSingular(), (int)this.itemStack.getCount());
    }

    public long getEnergyStoredLong() {
        return (long)this.getEnergyStoredSingular() * (long)this.itemStack.getCount();
    }

    public int getMaxEnergyStoredSingular() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        CompoundTag tag = this.itemStack.getOrCreateTag();
        if (!tag.contains(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName())) {
            return BlockEnergyBatteryConfig.capacity;
        }
        return tag.getInt(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
    }

    public int getMaxEnergyStored() {
        return Helpers.multiplySafe((int)this.getMaxEnergyStoredSingular(), (int)this.itemStack.getCount());
    }

    public long getMaxEnergyStoredLong() {
        return (long)this.getMaxEnergyStoredSingular() * (long)this.itemStack.getCount();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return 0;
        }
        int stackSize = this.itemStack.getCount();
        if (stackSize == 0) {
            return 0;
        }
        energy /= stackSize;
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStoredSingular();
        int energyReceived = Math.min(this.getMaxEnergyStoredSingular() - stored, energy);
        if (!simulate) {
            this.setItemStackEnergy(this.itemStack, stored + energyReceived);
        }
        return energyReceived * stackSize;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        int stackSize = this.itemStack.getCount();
        if (stackSize == 0) {
            return energy;
        }
        energy /= stackSize;
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStoredSingular();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setItemStackEnergy(this.itemStack, newEnergy);
        }
        return (stored - newEnergy) * stackSize;
    }

    protected void setItemStackEnergy(ItemStack itemStack, int energy) {
        if (this.isCreative()) {
            return;
        }
        CompoundTag tag = itemStack.getOrCreateTag();
        tag.putInt(this.itemBlockEnergyContainer.get().getEneryContainerNBTName(), energy);
    }

    @Override
    public void setCapacity(int capacity) {
        CompoundTag tag = this.itemStack.getOrCreateTag();
        if (capacity == BlockEnergyBatteryConfig.capacity) {
            tag.remove(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
        } else {
            tag.putInt(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName(), capacity);
        }
    }

    @Override
    public void setEnergy(int energy) {
        this.setItemStackEnergy(this.itemStack, energy);
    }
}

