/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.blockentity.BlockEntitySqueezer;
import org.joml.Matrix4f;

public class RenderBlockEntitySqueezer
implements BlockEntityRenderer<BlockEntitySqueezer> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.0625f;
    private static final float MAXY = 0.115f;
    private static final float MIN = 0.01f;
    private static final float MAX = 0.99f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.99f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.0625f, 0.01f}}, new float[][]{{0.01f, 0.0625f, 0.99f}, {0.01f, 0.115f, 0.99f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}, new float[][]{{0.01f, 0.0625f, 0.01f}, {0.01f, 0.115f, 0.01f}, {0.01f, 0.115f, 0.99f}, {0.01f, 0.0625f, 0.99f}}, new float[][]{{0.99f, 0.0625f, 0.01f}, {0.99f, 0.115f, 0.01f}, {0.99f, 0.115f, 0.99f}, {0.99f, 0.0625f, 0.99f}}};

    public RenderBlockEntitySqueezer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntitySqueezer tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            if (!tile.getInventory().getItem(0).isEmpty()) {
                matrixStack.pushPose();
                matrixStack.translate(-0.5f, -0.5f, -0.5f);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().getItem(0), tile);
                matrixStack.popPose();
            }
            if (!tile.getTank().isEmpty()) {
                FluidStack fluid = tile.getTank().getFluid();
                int combinedLightCorrected = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos().offset(Direction.UP.getNormal()));
                RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStack, () -> {
                    float height = Math.max(0.052500002f, (float)fluid.getAmount() * 0.0625f / 1000.0f + 0.0625f - 0.01f);
                    int brightness = Math.max(combinedLightCorrected, fluid.getFluid().getFluidType().getLightLevel(fluid));
                    int l2 = brightness >> 16 & 0xFFFF;
                    int i3 = brightness & 0xFFFF;
                    for (Direction side : DirectionHelpers.DIRECTIONS) {
                        TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                        Triple color = Helpers.intToRGB((int)renderProperties.getTintColor(fluid));
                        VertexConsumer vb = renderTypeBuffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
                        Matrix4f matrix = matrixStack.last().pose();
                        float[][] c = coordinates[side.ordinal()];
                        float replacedMaxV = side == Direction.UP || side == Direction.DOWN ? icon.getV1() : (icon.getV1() - icon.getV0()) * height + icon.getV0();
                        vb.vertex(matrix, c[0][0], RenderBlockEntitySqueezer.getHeight(side, c[0][1], height), c[0][2]).color(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).uv(icon.getU0(), replacedMaxV).uv2(l2, i3).endVertex();
                        vb.vertex(matrix, c[1][0], RenderBlockEntitySqueezer.getHeight(side, c[1][1], height), c[1][2]).color(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).uv(icon.getU0(), icon.getV0()).uv2(l2, i3).endVertex();
                        vb.vertex(matrix, c[2][0], RenderBlockEntitySqueezer.getHeight(side, c[2][1], height), c[2][2]).color(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).uv(icon.getU1(), icon.getV0()).uv2(l2, i3).endVertex();
                        vb.vertex(matrix, c[3][0], RenderBlockEntitySqueezer.getHeight(side, c[3][1], height), c[3][2]).color(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).uv(icon.getU1(), replacedMaxV).uv2(l2, i3).endVertex();
                    }
                });
            }
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, BlockEntitySqueezer tile) {
        matrixStack.pushPose();
        float yTop = (float)(9 - tile.getItemHeight()) * 0.125f;
        matrixStack.translate(1.0f, (yTop - 1.0f) / 2.0f + 1.0f, 1.0f);
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(itemStack, null, null, 0);
        if (model.isGui3d()) {
            matrixStack.scale(1.7f, 1.7f, 1.7f);
        }
        matrixStack.scale(1.0f, yTop - 0.125f, 1.0f);
        Minecraft.getInstance().getItemRenderer().renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, matrixStack, renderTypeBuffer, tile.getLevel(), 0);
        matrixStack.popPose();
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.115f) {
            return replaceHeight;
        }
        return height;
    }
}

