/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.block;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;

public class VoxelShapeComponents
extends VoxelShape
implements Iterable<VoxelShape> {
    private final Collection<Pair<VoxelShape, IComponent>> entries;
    private final String stateId;

    protected VoxelShapeComponents(Collection<Pair<VoxelShape, IComponent>> entries, String stateId) {
        super(VoxelShapeComponents.createInnerPart(entries));
        this.entries = entries;
        this.stateId = stateId;
    }

    protected static DiscreteVoxelShape createInnerPart(Collection<Pair<VoxelShape, IComponent>> entries) {
        return new Part(entries.stream().map(pair -> ((VoxelShape)pair.getLeft()).shape).collect(Collectors.toList()));
    }

    public static VoxelShapeComponents create(BlockState blockState, BlockGetter world, BlockPos blockPos, CollisionContext selectionContext, List<IComponent> components) {
        ArrayList entries = Lists.newArrayList();
        for (IComponent component : components) {
            VoxelShape shape = component.getShape(blockState, world, blockPos, selectionContext);
            entries.add(Pair.of((Object)shape, (Object)component));
        }
        StringBuilder stateIdBuilder = new StringBuilder();
        for (IComponent component : components) {
            stateIdBuilder.append(component.getStateId(blockState, world, blockPos));
            stateIdBuilder.append(";");
        }
        return new VoxelShapeComponents(entries, stateIdBuilder.toString());
    }

    public String getStateId() {
        return this.stateId;
    }

    @Override
    public Iterator<VoxelShape> iterator() {
        return this.entries.stream().map(Pair::getLeft).iterator();
    }

    public double min(Direction.Axis axis) {
        boolean first = true;
        double startMin = 0.0;
        for (VoxelShape shape : this) {
            double start = shape.min(axis);
            if (!first && !(start < startMin)) continue;
            startMin = start;
            first = false;
        }
        return startMin;
    }

    public double max(Direction.Axis axis) {
        boolean first = true;
        double endMax = 0.0;
        for (VoxelShape shape : this) {
            double end = shape.max(axis);
            if (!first && !(end > endMax)) continue;
            endMax = end;
            first = false;
        }
        return endMax;
    }

    public DoubleList getCoords(Direction.Axis axis) {
        DoubleArrayList values = new DoubleArrayList();
        for (VoxelShape shape : this) {
            values.addAll(shape.getCoords(axis));
        }
        return values;
    }

    public boolean isEmpty() {
        for (VoxelShape shape : this) {
            if (shape.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public VoxelShape move(double x, double y, double z) {
        ArrayList entries = Lists.newArrayList();
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            entries.add(Pair.of((Object)((VoxelShape)entry.getLeft()).move(x, y, z), (Object)((IComponent)entry.getRight())));
        }
        return new VoxelShapeComponents(entries, this.stateId);
    }

    public void forAllEdges(Shapes.DoubleLineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.forAllEdges(consumer);
        }
    }

    public void forAllBoxes(Shapes.DoubleLineConsumer consumer) {
        for (VoxelShape shape : this) {
            shape.forAllBoxes(consumer);
        }
    }

    public double max(Direction.Axis axis, double a, double b) {
        boolean first = true;
        double valueMax = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.max(axis, a, b);
            if (!first && !(value > valueMax)) continue;
            valueMax = value;
            first = false;
        }
        return valueMax;
    }

    @Nullable
    public BlockRayTraceResultComponent clip(Vec3 startVec, Vec3 endVec, BlockPos pos) {
        double distanceMin = Double.POSITIVE_INFINITY;
        IComponent componentMin = null;
        BlockHitResult resultMin = null;
        for (Pair<VoxelShape, IComponent> entry : this.entries) {
            double distance;
            VoxelShape shape = (VoxelShape)entry.getLeft();
            BlockHitResult result = shape.clip(startVec, endVec, pos);
            if (result == null || !((distance = result.getLocation().distanceToSqr(startVec)) < distanceMin) || resultMin != null && ((IComponent)entry.getRight()).isRaytraceLastForFace() && componentMin.getRaytraceDirection() == result.getDirection()) continue;
            distanceMin = distance;
            componentMin = (IComponent)entry.getRight();
            resultMin = result;
        }
        if (resultMin != null) {
            return new BlockRayTraceResultComponent(resultMin, componentMin);
        }
        return null;
    }

    @Nullable
    public BlockRayTraceResultComponent rayTrace(BlockPos pos, @Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        AttributeInstance reachDistanceAttribute = entity instanceof LivingEntity ? ((LivingEntity)entity).getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value()) : null;
        double reachDistance = reachDistanceAttribute == null ? 5.0 : reachDistanceAttribute.getValue();
        double eyeHeight = entity.getCommandSenderWorld().isClientSide() ? (double)entity.getEyeHeight() : (double)entity.getEyeHeight();
        Vec3 lookVec = entity.getLookAngle();
        Vec3 origin = new Vec3(entity.getX(), entity.getY() + eyeHeight, entity.getZ());
        Vec3 direction = origin.add(lookVec.x * reachDistance, lookVec.y * reachDistance, lookVec.z * reachDistance);
        return this.clip(origin, direction, pos);
    }

    public double collideX(AxisCycle rotation, AABB axisAlignedBB, double range) {
        boolean first = true;
        double valueBest = 0.0;
        for (VoxelShape shape : this) {
            double value = shape.collideX(rotation, axisAlignedBB, range);
            if (range > 0.0) {
                if (!first && !(value < valueBest)) continue;
                valueBest = value;
                first = false;
                continue;
            }
            if (!first && !(value > valueBest)) continue;
            valueBest = value;
            first = false;
        }
        return valueBest;
    }

    public static class Part
    extends DiscreteVoxelShape
    implements Iterable<DiscreteVoxelShape> {
        private final Collection<DiscreteVoxelShape> entries;

        public Part(Collection<DiscreteVoxelShape> entries) {
            super(0, 0, 0);
            this.entries = entries;
        }

        @Override
        public Iterator<DiscreteVoxelShape> iterator() {
            return this.entries.iterator();
        }

        public boolean isFullWide(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                if (!part.isFullWide(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public boolean isFull(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                if (!part.isFull(x, y, z)) continue;
                return true;
            }
            return false;
        }

        public void fill(int x, int y, int z) {
            for (DiscreteVoxelShape part : this) {
                part.fill(x, y, z);
            }
        }

        public int firstFull(Direction.Axis axis) {
            boolean first = true;
            int startMin = 0;
            for (DiscreteVoxelShape part : this) {
                int start = part.firstFull(axis);
                if (!first && start >= startMin) continue;
                startMin = start;
                first = false;
            }
            return startMin;
        }

        public int lastFull(Direction.Axis axis) {
            boolean first = true;
            int endMax = 0;
            for (DiscreteVoxelShape part : this) {
                int end = part.lastFull(axis);
                if (!first && end <= endMax) continue;
                endMax = end;
                first = false;
            }
            return endMax;
        }

        public int getSize(Direction.Axis axis) {
            boolean first = true;
            int sizeMax = 0;
            for (DiscreteVoxelShape part : this) {
                int size = part.getSize(axis);
                if (!first && size <= sizeMax) continue;
                sizeMax = size;
                first = false;
            }
            return sizeMax;
        }

        public void forAllBoxes(DiscreteVoxelShape.IntLineConsumer consumer, boolean p_197831_2_) {
            for (DiscreteVoxelShape part : this) {
                part.forAllBoxes(consumer, p_197831_2_);
            }
        }
    }

    public static interface IComponent {
        public String getStateId(BlockState var1, BlockGetter var2, BlockPos var3);

        public VoxelShape getShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

        public ItemStack getCloneItemStack(Level var1, BlockPos var2);

        public boolean destroy(Level var1, BlockPos var2, Player var3, boolean var4);

        @OnlyIn(value=Dist.CLIENT)
        @Nullable
        public BakedModel getBreakingBaseModel(Level var1, BlockPos var2);

        public InteractionResult onBlockActivated(BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockRayTraceResultComponent var6);

        @Nullable
        public Direction getRaytraceDirection();

        public boolean isRaytraceLastForFace();
    }
}

