/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.blockentity;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.IFacadeable;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCarrier;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.capability.cable.CableFakeableMultipartTicking;
import org.cyclops.integrateddynamics.capability.cable.CableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamiclight.DynamicLightTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableDefault;
import org.cyclops.integrateddynamics.capability.facadeable.FacadeableTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.network.NetworkCarrierDefault;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderPartContainer;
import org.cyclops.integrateddynamics.capability.partcontainer.PartContainerTileMultipartTicking;
import org.cyclops.integrateddynamics.capability.path.PathElementTileMultipartTicking;
import org.cyclops.integrateddynamics.client.model.CableRenderState;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.event.RegisterPartCapabilitiesEvent;

public class BlockEntityMultipartTicking
extends CyclopsBlockEntity
implements PartHelpers.IPartStateHolderCallback {
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> redstoneLevels = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneInputs = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> redstoneStrong = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lastRedstonePulses = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Integer> lightLevels = EnumFacingMap.newMap();
    private EnumFacingMap<Integer> previousLightLevels;
    @NBTPersist
    private CompoundTag facadeBlockTag = null;
    private final PartContainerTileMultipartTicking partContainer = new PartContainerTileMultipartTicking(this);
    private final CableTileMultipartTicking cable = new CableTileMultipartTicking(this);
    private final INetworkCarrier networkCarrier = new NetworkCarrierDefault();
    private final ICableFakeable cableFakeable = new CableFakeableMultipartTicking(this);
    @NBTPersist
    private boolean forceLightCheckAtClient;
    private ModelData cachedState = null;

    public BlockEntityMultipartTicking(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_MULTIPART_TICKING.get(), blockPos, blockState);
    }

    public static void registerMultipartTickingCapabilities(RegisterCapabilitiesEvent event, BlockEntityType<? extends BlockEntityMultipartTicking> blockEntityType) {
        event.registerBlockEntity(Capabilities.PartContainer.BLOCK, blockEntityType, (blockEntity, context) -> blockEntity.getPartContainer());
        event.registerBlockEntity(Capabilities.NetworkElementProvider.BLOCK, blockEntityType, (blockEntity, context) -> new NetworkElementProviderPartContainer(blockEntity.getPartContainer()));
        event.registerBlockEntity(Capabilities.Facadeable.BLOCK, blockEntityType, (blockEntity, context) -> new FacadeableTileMultipartTicking((BlockEntityMultipartTicking)blockEntity));
        event.registerBlockEntity(Capabilities.Cable.BLOCK, blockEntityType, (blockEntity, context) -> blockEntity.getCable());
        event.registerBlockEntity(Capabilities.NetworkCarrier.BLOCK, blockEntityType, (blockEntity, context) -> blockEntity.getNetworkCarrier());
        event.registerBlockEntity(Capabilities.CableFakeable.BLOCK, blockEntityType, (blockEntity, context) -> blockEntity.getCableFakeable());
        event.registerBlockEntity(Capabilities.PathElement.BLOCK, blockEntityType, (blockEntity, context) -> new PathElementTileMultipartTicking((BlockEntityMultipartTicking)blockEntity, (ICable)blockEntity.getCable()));
        BlockEntityMultipartTicking.registerPartCapabilityAsBlockCapability(event, blockEntityType, Capabilities.ValueInterface.BLOCK, Capabilities.ValueInterface.PART);
        BlockEntityMultipartTicking.registerPartCapabilityAsBlockCapability(event, blockEntityType, Capabilities.VariableContainer.BLOCK, Capabilities.VariableContainer.PART);
        ModLoader.get().postEventWrapContainerInModOrder((Event)new RegisterPartCapabilitiesEvent(event, blockEntityType));
        event.registerBlockEntity(Capabilities.DynamicLight.BLOCK, blockEntityType, DynamicLightTileMultipartTicking::new);
        event.registerBlockEntity(Capabilities.DynamicRedstone.BLOCK, blockEntityType, DynamicRedstoneTileMultipartTicking::new);
    }

    public static <T> void registerPartCapabilityAsBlockCapability(RegisterCapabilitiesEvent event, BlockEntityType<? extends BlockEntityMultipartTicking> blockEntityType, BlockCapability<T, Direction> blockCapability, PartCapability<T> partCapability) {
        event.registerBlockEntity(blockCapability, blockEntityType, (blockEntity, context) -> {
            INetwork network = blockEntity.getNetwork();
            if (network != null) {
                IPartNetwork partNetwork = NetworkHelpers.getPartNetworkChecked(network);
                return blockEntity.getPartContainer().getCapability(partCapability, network, partNetwork, PartTarget.fromCenter(PartPos.of(blockEntity.getLevel(), blockEntity.getBlockPos(), context))).orElse(null);
            }
            return null;
        });
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        this.forceLightCheckAtClient = false;
        tag.put("partContainer", (Tag)this.partContainer.serializeNBT());
        tag.putBoolean("realCable", this.cableFakeable.isRealCable());
    }

    public void read(CompoundTag tag) {
        boolean isLightTransparent;
        EnumFacingMap lastConnected = EnumFacingMap.newMap(this.connected);
        CompoundTag lastFacadeBlock = this.facadeBlockTag;
        boolean lastRealCable = this.cableFakeable.isRealCable();
        this.partContainer.deserializeNBT(tag.getCompound("partContainer"));
        boolean wasLightTransparent = this.getLevel() != null && CableHelpers.isLightTransparent(this.getLevel(), this.getBlockPos(), null);
        super.read(tag);
        this.cableFakeable.setRealCable(tag.getBoolean("realCable"));
        boolean bl = isLightTransparent = this.getLevel() != null && CableHelpers.isLightTransparent(this.getLevel(), this.getBlockPos(), null);
        if (!(this.getLevel() == null || lastConnected != null && this.connected != null && lastConnected.equals(this.connected) && Objects.equals(lastFacadeBlock, this.facadeBlockTag) && lastRealCable == this.cableFakeable.isRealCable() && wasLightTransparent == isLightTransparent)) {
            BlockHelpers.markForUpdate((Level)this.getLevel(), (BlockPos)this.getBlockPos());
        }
    }

    public void onUpdateReceived() {
        if (!this.lightLevels.equals(this.previousLightLevels)) {
            this.previousLightLevels = this.lightLevels;
        }
        this.cachedState = null;
        BlockHelpers.markForUpdate((Level)this.getLevel(), (BlockPos)this.getBlockPos());
        if (this.forceLightCheckAtClient) {
            this.getLevel().getLightEngine().checkBlock(this.getBlockPos());
        }
    }

    public ModelData getConnectionState() {
        if (this.cachedState != null) {
            return this.cachedState;
        }
        ModelData.Builder builder = ModelData.builder();
        if (this.partContainer.getPartData() != null) {
            builder.with(BlockCable.REALCABLE, (Object)this.cableFakeable.isRealCable());
            if (this.connected.isEmpty()) {
                this.getCable().updateConnections();
            }
            for (Direction side : Direction.values()) {
                builder.with(BlockCable.CONNECTED[side.ordinal()], (Object)(!this.cable.isForceDisconnected(side) && (Boolean)this.connected.get((Object)side) != false ? 1 : 0));
                builder.with(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)(this.partContainer.hasPart(side) ? this.partContainer.getPart(side).getPartRenderPosition() : PartRenderPosition.NONE));
            }
            IFacadeable facadeable = Optional.ofNullable((IFacadeable)this.level.getCapability(Capabilities.Facadeable.BLOCK, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, null)).orElseGet(FacadeableDefault::new);
            builder.with(BlockCable.FACADE, facadeable.hasFacade() ? Optional.of(facadeable.getFacade()) : Optional.empty());
            builder.with(BlockCable.PARTCONTAINER, (Object)this.partContainer);
            builder.with(BlockCable.RENDERSTATE, (Object)new CableRenderState(this.cableFakeable.isRealCable(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap(this.connected), EnumFacingMap.newMap(this.partContainer.getPartData()), (Tag)this.facadeBlockTag));
        }
        this.cachedState = builder.build();
        return this.cachedState;
    }

    public void updateRedstoneInfo(Direction side, boolean strongPower) {
        this.setChanged();
        if (this.getLevel().isLoaded(this.getBlockPos().relative(side))) {
            this.getLevel().neighborChanged(this.getBlockPos().relative(side), this.getBlockState().getBlock(), this.getBlockPos());
            if (strongPower) {
                this.getLevel().updateNeighborsAt(this.getBlockPos().relative(side), this.getBlockState().getBlock());
            }
        }
    }

    public void updateLightInfo() {
        this.sendUpdate();
    }

    public INetwork getNetwork() {
        return this.networkCarrier.getNetwork();
    }

    @Override
    public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    public void setForceDisconnected(EnumFacingMap<Boolean> forceDisconnected) {
        this.forceDisconnected.clear();
        this.forceDisconnected.putAll(forceDisconnected);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.invalidateParts();
    }

    protected void invalidateParts() {
        INetwork network;
        if (this.getLevel() != null && !this.getLevel().isClientSide && (network = this.getNetwork()) != null) {
            for (Map.Entry entry : this.partContainer.getPartData().entrySet()) {
                INetworkElement element = ((PartHelpers.PartStateHolder)entry.getValue()).getPart().createNetworkElement(this.getPartContainer(), DimPos.of((Level)this.getLevel(), (BlockPos)this.getBlockPos()), (Direction)entry.getKey());
                element.invalidate(network);
            }
        }
    }

    protected Direction transformFacingForRotation(Direction facing) {
        return facing;
    }

    public EnumFacingMap<Boolean> getConnected() {
        return this.connected;
    }

    public EnumFacingMap<Integer> getRedstoneLevels() {
        return this.redstoneLevels;
    }

    public EnumFacingMap<Boolean> getRedstoneInputs() {
        return this.redstoneInputs;
    }

    public EnumFacingMap<Boolean> getRedstoneStrong() {
        return this.redstoneStrong;
    }

    public EnumFacingMap<Integer> getLastRedstonePulses() {
        return this.lastRedstonePulses;
    }

    public EnumFacingMap<Integer> getLightLevels() {
        return this.lightLevels;
    }

    public CompoundTag getFacadeBlockTag() {
        return this.facadeBlockTag;
    }

    public void setFacadeBlockTag(CompoundTag facadeBlockTag) {
        this.facadeBlockTag = facadeBlockTag;
    }

    public PartContainerTileMultipartTicking getPartContainer() {
        return this.partContainer;
    }

    public CableTileMultipartTicking getCable() {
        return this.cable;
    }

    public INetworkCarrier getNetworkCarrier() {
        return this.networkCarrier;
    }

    public ICableFakeable getCableFakeable() {
        return this.cableFakeable;
    }

    public void setForceLightCheckAtClient(boolean forceLightCheckAtClient) {
        this.forceLightCheckAtClient = forceLightCheckAtClient;
    }

    public static class Ticker<T extends BlockEntityMultipartTicking>
    extends BlockEntityTickerDelayed<T> {
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityMultipartTicking)blockEntity).getConnected().isEmpty()) {
                ((BlockEntityMultipartTicking)blockEntity).getCable().updateConnections();
            }
            ((BlockEntityMultipartTicking)blockEntity).getPartContainer().update();
            if (((BlockEntityMultipartTicking)blockEntity).getNetwork() == null) {
                NetworkHelpers.revalidateNetworkElements(level, pos);
            }
        }
    }
}

