/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.client.gui.image.Images;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;

public abstract class ContainerScreenMultipart<P extends IPartType<P, S>, S extends IPartState<P>, C extends ContainerMultipart<P, S>>
extends ContainerScreenExtended<C> {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();

    public ContainerScreenMultipart(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    public void init() {
        this.clearWidgets();
        super.init();
        Object partType = ((ContainerMultipart)this.getMenu()).getPartType();
        if (partType instanceof PartTypeConfigurable && partType.getContainerProviderSettings(null).isPresent()) {
            this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos - 20, this.topPos + 0, 18, 18, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings"), this.createServerPressable("button_settings", button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_SETTINGS}, false, 0, 0));
            if (((ContainerMultipart)this.getMenu()).getPartType().supportsOffsets()) {
                this.addRenderableWidget((GuiEventListener)new ButtonImage(this.leftPos - 20, this.topPos + 20, 18, 18, (Component)Component.translatable((String)"gui.integrateddynamics.part_offsets"), this.createServerPressable("button_offsets", button -> {}), new IImage[]{Images.BUTTON_BACKGROUND_INACTIVE, Images.BUTTON_MIDDLE_OFFSET}, false, 0, 0));
            }
        }
    }

    protected abstract String getNameId();

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/" + this.getNameId() + ".png");
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.font.drawInBatch(this.getTitle(), (float)(this.leftPos + 8), (float)(this.topPos + 6), 0x404040, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isHovering(-20, 0, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.part_settings")}), guiGraphics.pose(), mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (this.isHovering(-20, 20, 18, 18, mouseX, mouseY)) {
            this.drawTooltip(Lists.newArrayList((Object[])new Component[]{Component.translatable((String)"gui.integrateddynamics.part_offsets")}), guiGraphics.pose(), mouseX - this.leftPos, mouseY - this.topPos);
        }
    }
}

