/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DelegatingChildDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.item.ItemVariable;

public class VariableModelBaked
extends DelegatingChildDynamicItemAndBlockModel
implements IVariableModelBaked {
    private final Map<IVariableModelProvider, IVariableModelProvider.BakedModelProvider> subModels = Maps.newHashMap();

    public VariableModelBaked(BakedModel parent) {
        super(parent);
    }

    @Override
    public <B extends IVariableModelProvider.BakedModelProvider> void setSubModels(IVariableModelProvider<B> provider, B subModels) {
        this.subModels.put(provider, subModels);
    }

    @Override
    public <B extends IVariableModelProvider.BakedModelProvider> B getSubModels(IVariableModelProvider<B> provider) {
        return (B)this.subModels.get(provider);
    }

    public BakedModel handleBlockState(BlockState state, Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        return null;
    }

    public BakedModel handleItemState(ItemStack itemStack, Level world, LivingEntity entity) {
        LinkedList quads = Lists.newLinkedList();
        quads.addAll(this.baseModel.getQuads(null, this.getRenderingSide(), this.rand, this.modelData, null));
        IVariableFacade variableFacade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(ValueDeseralizationContext.of(world), itemStack);
        variableFacade.addModelOverlay(this, quads, this.rand, this.modelData);
        return new SimpleBakedModel((List)quads, ModelHelpers.EMPTY_FACE_QUADS, this.useAmbientOcclusion(), this.usesBlockLight(), this.isGui3d(), this.getParticleIcon(), this.getTransforms(), this.getOverrides(), RenderTypeGroup.EMPTY);
    }

    public boolean usesBlockLight() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    public ItemTransforms getTransforms() {
        return ModelHelpers.DEFAULT_CAMERA_TRANSFORMS_ITEM;
    }

    public ItemOverrides getOverrides() {
        return new ItemOverrides(){

            @Nullable
            public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity livingEntity, int id) {
                IVariableFacade variableFacade = ((ItemVariable)((Object)RegistryEntries.ITEM_VARIABLE.get())).getVariableFacade(ValueDeseralizationContext.of((Level)world), stack);
                BakedModel overrideModel = variableFacade.getVariableItemOverrideModel(model, stack, world, livingEntity);
                if (overrideModel != null) {
                    return overrideModel;
                }
                return VariableModelBaked.super.getOverrides().resolve(model, stack, world, livingEntity, id);
            }

            public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
                return VariableModelBaked.this.baseModel.getOverrides().getOverrides();
            }
        };
    }
}

