/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;

public class InventoryVariableEvaluator<V extends IValue>
implements IVariableFacade.IValidator {
    private final IVariableFacadeHandlerRegistry handler = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
    private final Container inventory;
    private final int slot;
    private final ValueDeseralizationContext valueDeseralizationContext;
    private final IValueType containingValueType;
    private IVariableFacade variableStored = null;
    private List<MutableComponent> errors = Lists.newLinkedList();

    public InventoryVariableEvaluator(Container inventory, int slot, ValueDeseralizationContext valueDeseralizationContext, IValueType<V> containingValueType) {
        this.inventory = inventory;
        this.slot = slot;
        this.valueDeseralizationContext = valueDeseralizationContext;
        this.containingValueType = containingValueType;
    }

    public boolean hasVariable() {
        return !this.inventory.getItem(this.slot).isEmpty();
    }

    public void refreshVariable(@Nullable INetwork network, boolean sendVariablesUpdateEvent) {
        IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network).orElse(null);
        int lastVariabledId = this.variableStored == null ? -1 : this.variableStored.getId();
        int variableId = -1;
        if (!this.inventory.getItem(this.slot).isEmpty() && NetworkHelpers.shouldWork()) {
            ItemStack itemStack = this.inventory.getItem(this.slot);
            this.variableStored = this.handler.handle(this.valueDeseralizationContext, itemStack);
            if (this.variableStored != null) {
                variableId = this.variableStored.getId();
            }
        } else {
            this.variableStored = null;
        }
        this.clearErrors();
        if (partNetwork == null) {
            this.addError(Component.translatable((String)"general.integrateddynamics.error.no_network"));
        } else if (this.variableStored != null) {
            this.preValidate();
            try {
                this.variableStored.validate(network, partNetwork, this, this.containingValueType);
            }
            catch (IllegalArgumentException e) {
                this.addError(Component.translatable((String)e.getMessage()));
            }
        }
        if (sendVariablesUpdateEvent && partNetwork != null && lastVariabledId != variableId) {
            network.getEventBus().post(new VariableContentsUpdatedEvent(network));
        }
    }

    @Nullable
    public IVariable<V> getVariable(INetwork network) {
        return this.getVariable(network, NetworkHelpers.getPartNetworkChecked(network));
    }

    @Nullable
    public IVariable<V> getVariable(INetwork network, IPartNetwork partNetwork) {
        if (this.getVariableFacade() == null || !this.getErrors().isEmpty()) {
            return null;
        }
        try {
            return this.getVariableFacade().getVariable(network, partNetwork);
        }
        catch (IllegalArgumentException e) {
            this.addError(Component.translatable((String)e.getMessage()));
            return null;
        }
    }

    public IVariableFacade getVariableFacade() {
        return this.variableStored;
    }

    protected void preValidate() {
    }

    public void clearErrors() {
        this.errors.clear();
        this.onErrorsChanged();
    }

    public void setErrors(List<MutableComponent> errors) {
        this.errors = errors;
        this.onErrorsChanged();
    }

    public List<MutableComponent> getErrors() {
        return this.errors;
    }

    @Override
    public void addError(MutableComponent error) {
        this.errors.add(error);
        this.onErrorsChanged();
    }

    public void onErrorsChanged() {
    }
}

