/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorRegistry;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperatorSerializer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IOperatorVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.expression.LazyExpression;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorSerializerDefault;
import org.cyclops.integrateddynamics.core.item.OperatorVariableFacade;

public class OperatorRegistry
implements IOperatorRegistry {
    private static OperatorRegistry INSTANCE = new OperatorRegistry();
    private static final IOperatorVariableFacade INVALID_FACADE = new OperatorVariableFacade(false, null, null);
    private final List<IOperator> operators = Lists.newArrayList();
    private final Map<String, IOperator> namedOperators = Maps.newHashMap();
    private final Map<String, IOperator> globalInteractOperators = Maps.newHashMap();
    private final Map<IValueType<?>, Map<String, IOperator>> scopedInteractOperators = Maps.newHashMap();
    private final Multimap<List<IValueType>, IOperator> inputTypedOperators = HashMultimap.create();
    private final Multimap<IValueType, IOperator> outputTypedOperators = HashMultimap.create();
    private final Multimap<String, IOperator> categoryOperators = HashMultimap.create();
    private final List<IOperatorSerializer> serializers = Lists.newArrayList();
    private final Map<String, IOperatorSerializer> namedSerializers = Maps.newHashMap();
    private final IOperatorSerializer DEFAULT_SERIALIZER = new OperatorSerializerDefault();

    private OperatorRegistry() {
        if (MinecraftHelpers.isModdedEnvironment()) {
            ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).registerHandler(this);
        }
    }

    public static OperatorRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <O extends IOperator> O register(O operator) {
        this.operators.add(operator);
        this.namedOperators.put(operator.getUniqueName().toString(), operator);
        this.inputTypedOperators.put((Object)ImmutableList.copyOf((Object[])operator.getInputTypes()), operator);
        this.outputTypedOperators.put((Object)operator.getOutputType(), operator);
        this.categoryOperators.put((Object)operator.getUnlocalizedCategoryName(), operator);
        String globalInteractName = operator.getGlobalInteractName();
        if (this.globalInteractOperators.containsKey(globalInteractName)) {
            throw new IllegalStateException("Detected registration of an operator with non-unique global interact name: " + operator.getUniqueName().toString() + ", " + this.globalInteractOperators.get(globalInteractName).getUniqueName().toString());
        }
        this.globalInteractOperators.put(globalInteractName, operator);
        if (operator.getInputTypes().length > 0) {
            String scopedInteractName;
            HashMap scopedIteracts = this.scopedInteractOperators.get(operator.getInputTypes()[0]);
            if (scopedIteracts == null) {
                scopedIteracts = Maps.newHashMap();
                this.scopedInteractOperators.put(operator.getInputTypes()[0], scopedIteracts);
            }
            if (scopedIteracts.containsKey(scopedInteractName = operator.getScopedInteractName())) {
                throw new IllegalStateException("Detected registration of an operator with non-unique scoped interact name: " + operator.getUniqueName().toString() + ", " + ((IOperator)scopedIteracts.get(scopedInteractName)).getUniqueName().toString());
            }
            scopedIteracts.put(scopedInteractName, operator);
        }
        return operator;
    }

    @Override
    public Collection<IOperator> getOperators() {
        return Collections.unmodifiableList(this.operators);
    }

    @Override
    public IOperator getOperator(ResourceLocation uniqueName) {
        return this.namedOperators.get(uniqueName.toString());
    }

    @Override
    public Collection<IOperator> getOperatorsWithInputTypes(IValueType ... valueTypes) {
        return this.inputTypedOperators.get((Object)ImmutableList.copyOf((Object[])valueTypes));
    }

    @Override
    public Collection<IOperator> getOperatorsWithOutputType(IValueType valueType) {
        return this.outputTypedOperators.get((Object)valueType);
    }

    @Override
    public Collection<IOperator> getOperatorsInCategory(String categoryName) {
        return this.categoryOperators.get((Object)categoryName);
    }

    @Override
    public void registerSerializer(IOperatorSerializer serializer) {
        this.serializers.add(serializer);
        this.namedSerializers.put(serializer.getUniqueName().toString(), serializer);
    }

    @Override
    public Tag serialize(IOperator value) {
        for (IOperatorSerializer serializer : this.serializers) {
            if (!serializer.canHandle(value)) continue;
            CompoundTag tag = new CompoundTag();
            tag.putString("serializer", serializer.getUniqueName().toString());
            tag.put("value", serializer.serialize(value));
            return tag;
        }
        return this.DEFAULT_SERIALIZER.serialize(value);
    }

    @Override
    public IOperator deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) throws EvaluationException {
        if (value.getId() == 10) {
            CompoundTag tag = (CompoundTag)value;
            String serializerName = tag.getString("serializer");
            IOperatorSerializer serializer = this.namedSerializers.get(serializerName);
            if (serializer == null) {
                throw new EvaluationException(Component.translatable((String)"operator.integrateddynamics.error.no_derserializer", (Object[])new Object[]{value}));
            }
            return serializer.deserialize(valueDeseralizationContext, tag.get("value"));
        }
        return this.DEFAULT_SERIALIZER.deserialize(valueDeseralizationContext, value);
    }

    @Override
    public ResourceLocation getUniqueName() {
        return new ResourceLocation("integrateddynamics", "operator");
    }

    @Override
    public IOperatorVariableFacade getVariableFacade(ValueDeseralizationContext valueDeseralizationContext, int id, CompoundTag tag) {
        IOperator operator;
        if (!tag.contains("operatorName", 8) || !tag.contains("variableIds", 11)) {
            return INVALID_FACADE;
        }
        try {
            operator = this.deserialize(valueDeseralizationContext, tag.get("operatorName"));
        }
        catch (EvaluationException e) {
            return INVALID_FACADE;
        }
        if (operator == null) {
            return INVALID_FACADE;
        }
        int[] variableIds = tag.getIntArray("variableIds");
        return new OperatorVariableFacade(id, operator, variableIds);
    }

    @Override
    public void setVariableFacade(CompoundTag tag, IOperatorVariableFacade variableFacade) {
        tag.put("operatorName", this.serialize(variableFacade.getOperator()));
        tag.putIntArray("variableIds", variableFacade.getVariableIds());
    }

    @Override
    public boolean isInstance(IVariableFacade variableFacade) {
        return variableFacade instanceof IOperatorVariableFacade;
    }

    @Override
    public boolean isInstance(IVariable<?> variable) {
        return variable instanceof IVariable;
    }

    @Override
    public Map<String, IOperator> getGlobalInteractOperators() {
        return this.globalInteractOperators;
    }

    @Override
    public Map<IValueType<?>, Map<String, IOperator>> getScopedInteractOperators() {
        return this.scopedInteractOperators;
    }

    public static class OperatorVariablePredicate
    extends VariablePredicate<LazyExpression> {
        private final Optional<IOperator> operator;
        private final Optional<Int2ObjectMap<VariablePredicate>> inputPredicates;

        public OperatorVariablePredicate(Optional<IValueType> valueType, Optional<ValuePredicate> valuePredicate, Optional<IOperator> operator, Optional<Map<Integer, VariablePredicate>> inputPredicates) {
            super(LazyExpression.class, valueType, valuePredicate);
            this.operator = operator;
            this.inputPredicates = inputPredicates.map(Int2ObjectOpenHashMap::new);
        }

        public Optional<IOperator> getOperator() {
            return this.operator;
        }

        @Override
        protected boolean testTyped(LazyExpression variable) {
            if (!super.testTyped(variable) || !this.operator.isEmpty() && variable.getOperator() != this.operator.get()) {
                return false;
            }
            if (this.inputPredicates.isPresent()) {
                Int2ObjectMap<VariablePredicate> inputPredicatesMap = this.inputPredicates.get();
                for (int i = 0; i < variable.getInput().length; ++i) {
                    IVariable inputVariable = variable.getInput()[i];
                    VariablePredicate variablePredicate = (VariablePredicate)inputPredicatesMap.get(i);
                    if (variablePredicate == null || variablePredicate.test(inputVariable)) continue;
                    return false;
                }
            }
            return true;
        }

        public Optional<Map<Integer, VariablePredicate>> getInputPredicates() {
            return this.inputPredicates.map(map -> map);
        }
    }
}

