/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.DistExecutor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeEntity
extends ValueObjectTypeBase<ValueEntity>
implements IValueTypeNamed<ValueEntity>,
IValueTypeUniquelyNamed<ValueEntity>,
IValueTypeNullable<ValueEntity> {
    public ValueObjectTypeEntity() {
        super("entity", ValueEntity.class);
    }

    @Override
    public ValueEntity getDefault() {
        return ValueEntity.of((UUID)null);
    }

    @Override
    public MutableComponent toCompactString(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            Optional<Entity> entity = value.getRawValue();
            if (entity.isPresent()) {
                Entity e = entity.get();
                if (e instanceof ItemEntity) {
                    return (MutableComponent)((ItemEntity)e).getItem().getHoverName();
                }
                return (MutableComponent)e.getName();
            }
            return Component.literal((String)"unknown");
        }
        return Component.literal((String)"");
    }

    @Override
    public Tag serialize(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            return StringTag.valueOf((String)uuid.get().toString());
        }
        return StringTag.valueOf((String)"");
    }

    @Override
    public ValueEntity deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        try {
            return ValueEntity.of(UUID.fromString(value.getAsString()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ValueEntity.of((UUID)null);
        }
    }

    @Override
    public String getName(ValueEntity a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueEntity a) {
        return !a.getRawValue().isPresent();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return null;
    }

    @Override
    public String getUniqueName(ValueEntity value) {
        Optional<UUID> uuid = value.getUuid();
        if (uuid.isPresent()) {
            UUID id = uuid.get();
            String entityName = value.getRawValue().map(entity -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString()).orElse("unknown");
            return id.toString() + " (" + entityName + ")";
        }
        return "";
    }

    public static class ValueEntity
    extends ValueBase {
        private final Optional<UUID> value;

        protected ValueEntity(@Nullable Entity value) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = value == null ? Optional.empty() : Optional.of(value.getUUID());
        }

        private ValueEntity(@Nullable UUID entityUuid) {
            super(ValueTypes.OBJECT_ENTITY);
            this.value = Optional.ofNullable(entityUuid);
        }

        public Optional<Entity> getRawValue() {
            Optional<UUID> uuid = this.getUuid();
            if (uuid.isPresent()) {
                Optional optionalEntity = (Optional)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
                    if (MinecraftHelpers.isClientSideThread()) {
                        for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
                            if (!entity.getUUID().equals(uuid.get())) continue;
                            return Optional.of(entity);
                        }
                        return Optional.empty();
                    }
                    return null;
                });
                if (optionalEntity == null) {
                    for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
                        Entity entity = world.getEntity(uuid.get());
                        if (entity == null) continue;
                        return Optional.of(entity);
                    }
                } else {
                    return optionalEntity;
                }
            }
            return Optional.empty();
        }

        public Optional<UUID> getUuid() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o instanceof ValueEntity) {
                if (((ValueEntity)o).value.isPresent() && this.value.isPresent()) {
                    return ((ValueEntity)o).value.get().equals(this.value.get());
                }
                if (!((ValueEntity)o).value.isPresent() && !this.value.isPresent()) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.getType().hashCode() + (this.getRawValue().isPresent() ? this.getRawValue().get().hashCode() : 0);
        }

        public static ValueEntity of(@Nullable Entity entity) {
            return new ValueEntity(entity);
        }

        public static ValueEntity of(@Nullable UUID entityUuid) {
            return new ValueEntity(entityUuid);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeEntity.ValueEntity(value=" + this.value + ")";
        }
    }

    public static class ValueEntityPredicate
    extends ValuePredicate<ValueEntity> {
        private final Optional<EntityType<? extends Entity>> entityType;

        public ValueEntityPredicate(Optional<EntityType<? extends Entity>> entityType) {
            super(Optional.of(ValueTypes.OBJECT_ENTITY), Optional.empty(), Optional.empty());
            this.entityType = entityType;
        }

        public Optional<EntityType<? extends Entity>> getEntityType() {
            return this.entityType;
        }

        @Override
        protected boolean testTyped(ValueEntity value) {
            return super.testTyped(value) && (this.entityType.isEmpty() || value.getRawValue().isPresent() && value.getRawValue().get().getType() == this.entityType.get());
        }
    }
}

