/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;

public abstract class ValueTypeListProxyEntityBase<T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V>
implements INBTProvider {
    private String world;
    private int entity;

    public ValueTypeListProxyEntityBase(ResourceLocation name, T valueType, Level world, Entity entity) {
        super(name, valueType);
        this.world = (world == null ? Level.OVERWORLD : world.dimension()).location().toString();
        this.entity = entity == null ? -1 : entity.getId();
    }

    protected Entity getEntity() {
        ServerLevel worldServer = ServerLifecycleHooks.getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(this.world)));
        if (worldServer != null) {
            return worldServer.getEntity(this.entity);
        }
        return null;
    }

    public void writeGeneratedFieldsToNBT(CompoundTag tag) {
        tag.putString("world", this.world);
        tag.putInt("entity", this.entity);
    }

    public void readGeneratedFieldsFromNBT(CompoundTag tag) {
        this.world = tag.getString("world");
        this.entity = tag.getInt("entity");
    }
}

