/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyFactories;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.Variable;

public class ValueTypeListProxyLazyBuilt<T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private Cache<Integer, V> cache_values = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).maximumSize(100L).build();
    private final V value;
    private final IOperator operator;

    public ValueTypeListProxyLazyBuilt(V value, IOperator operator) {
        super(ValueTypeListProxyFactories.LAZY_BUILT.getName(), value.getType());
        this.value = value;
        this.operator = operator;
    }

    @Override
    public int getLength() throws EvaluationException {
        return Integer.MAX_VALUE;
    }

    @Override
    public V get(int index) throws EvaluationException {
        if (index == 0) {
            return this.value;
        }
        IValue current = (IValue)this.cache_values.getIfPresent((Object)index);
        if (current != null) {
            return (V)current;
        }
        V previous = this.get(index - 1);
        current = this.operator.evaluate(new Variable<V>(previous.getType(), previous));
        this.cache_values.put((Object)index, (Object)current);
        return (V)current;
    }

    @Override
    public boolean isInfinite() {
        return true;
    }

    public static class Factory
    extends ValueTypeListProxyNBTFactorySimple<IValueType<IValue>, IValue, ValueTypeListProxyLazyBuilt<IValueType<IValue>, IValue>> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "lazybuilt");
        }

        @Override
        protected void serializeNbt(ValueTypeListProxyLazyBuilt<IValueType<IValue>, IValue> value, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.putString("valueType", value.value.getType().getUniqueName().toString());
            tag.put("value", ValueHelpers.serializeRaw(value.value));
            tag.put("operator", Operators.REGISTRY.serialize(value.operator));
        }

        @Override
        protected ValueTypeListProxyLazyBuilt<IValueType<IValue>, IValue> deserializeNbt(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException, EvaluationException {
            IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(tag.getString("valueType")));
            Object value = ValueHelpers.deserializeRaw(valueDeseralizationContext, valueType, tag.get("value"));
            IOperator operator = Operators.REGISTRY.deserialize(valueDeseralizationContext, tag.get("operator"));
            return new ValueTypeListProxyLazyBuilt<IValueType<IValue>, IValue>((IValue)value, operator);
        }
    }
}

