/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyMaterialized;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueTypeListProxyMaterializedFactory
implements IValueTypeListProxyFactoryTypeRegistry.IProxyFactory<IValueType<IValue>, IValue, ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integrateddynamics", "materialized");
    }

    @Override
    public Tag serialize(ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> values) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        Object valueType = values.getValueType();
        boolean heterogeneous = false;
        try {
            if (valueType.isCategory() && values.getLength() > 0) {
                heterogeneous = true;
            }
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        tag.putString("valueType", valueType.getUniqueName().toString());
        tag.put("values", (Tag)list);
        for (IValue value : values) {
            Tag valueSerialized = ValueHelpers.serializeRaw(value);
            if (heterogeneous) {
                CompoundTag valueTag = new CompoundTag();
                valueTag.putString("valueType", value.getType().getUniqueName().toString());
                valueTag.put("value", valueSerialized);
                list.add((Object)valueTag);
                continue;
            }
            list.add((Object)valueSerialized);
        }
        return tag;
    }

    @Override
    public ValueTypeListProxyMaterialized<IValueType<IValue>, IValue> deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
        if (!(value instanceof CompoundTag)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is not a CompoundTag.", value));
        }
        CompoundTag tag = (CompoundTag)value;
        if (!tag.contains("valueType", 8)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is missing a valueType.", value));
        }
        if (!tag.contains("values", 9)) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the materialized list value '%s' as it is missing values.", value));
        }
        String valueTypeName = tag.getString("valueType");
        IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(valueTypeName));
        if (valueType == null) {
            throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", valueTypeName));
        }
        boolean heterogeneous = valueType.isCategory();
        IValueType elementValueType = valueType;
        ImmutableList.Builder builder = ImmutableList.builder();
        ListTag list = (ListTag)tag.get("values");
        for (Tag valueTag : list) {
            Tag valueSerialized;
            if (heterogeneous) {
                String subValueTypeName = ((CompoundTag)valueTag).getString("valueType");
                elementValueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(subValueTypeName));
                if (elementValueType == null) {
                    throw new IValueTypeListProxyFactoryTypeRegistry.SerializationException(String.format("Could not deserialize the serialized materialized list proxy value because the value type by name '%s' was not found.", subValueTypeName));
                }
                valueSerialized = ((CompoundTag)valueTag).get("value");
            } else {
                valueSerialized = valueTag;
            }
            Object deserializedValue = ValueHelpers.deserializeRaw(valueDeseralizationContext, elementValueType, valueSerialized);
            builder.add(deserializedValue);
        }
        return new ValueTypeListProxyMaterialized<IValueType<IValue>, IValue>(valueType, (List<IValue>)builder.build());
    }
}

