/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public abstract class ValueTypeListProxyNbtAsListGeneric<N extends Tag, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final Optional<Tag> tag;

    public ValueTypeListProxyNbtAsListGeneric(ResourceLocation name, T valueType, Optional<Tag> tag) {
        super(name, valueType);
        this.tag = tag;
    }

    public Optional<Tag> getTag() {
        return this.tag;
    }

    @Override
    public int getLength() throws EvaluationException {
        try {
            return this.getTag().map(t -> this.getLength(t)).orElse(0);
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    @Override
    public V get(int index) throws EvaluationException {
        try {
            if (index < this.getLength()) {
                return (V)((IValue)this.getTag().map(t -> this.get(t, index)).orElse(null));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected abstract int getLength(N var1);

    protected abstract V get(N var1, int var2);

    public static abstract class Factory<L extends ValueTypeListProxyNbtAsListGeneric<N, T, V>, N extends Tag, T extends IValueType<V>, V extends IValue>
    extends ValueTypeListProxyNBTFactorySimple<T, V, L> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "nbt.list_as_value");
        }

        @Override
        protected void serializeNbt(L value, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            if (((ValueTypeListProxyNbtAsListGeneric)value).getTag().isPresent()) {
                tag.put("tag", ((ValueTypeListProxyNbtAsListGeneric)value).getTag().get());
            }
        }

        @Override
        protected L deserializeNbt(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            return this.create(Optional.ofNullable(tag.get("tag")));
        }

        protected abstract L create(Optional<Tag> var1);
    }
}

