/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxyFactoryTypeRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeListProxyNBTFactorySimple;

public abstract class ValueTypeListProxyNbtValueListGeneric<N extends Tag, T extends IValueType<V>, V extends IValue>
extends ValueTypeListProxyBase<T, V> {
    private final String key;
    private final Optional<CompoundTag> tag;

    public ValueTypeListProxyNbtValueListGeneric(ResourceLocation name, T valueType, String key, Optional<Tag> tag) {
        super(name, valueType);
        this.key = key;
        this.tag = tag.filter(t -> t instanceof CompoundTag).map(t -> (CompoundTag)t);
    }

    public String getKey() {
        return this.key;
    }

    public Optional<CompoundTag> getTag() {
        return this.tag;
    }

    @Override
    public int getLength() throws EvaluationException {
        try {
            return this.getTag().map(t -> Optional.ofNullable(t.get(this.key))).orElse(Optional.empty()).map(this::getLength).orElse(0);
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    @Override
    public V get(int index) throws EvaluationException {
        try {
            if (index < this.getLength()) {
                return (V)((IValue)this.getTag().map(t -> Optional.ofNullable(t.get(this.key))).orElse(Optional.empty()).map(t -> this.get(t, index)).orElse(null));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    protected abstract int getLength(N var1);

    protected abstract V get(N var1, int var2);

    public static abstract class Factory<L extends ValueTypeListProxyNbtValueListGeneric<N, T, V>, N extends Tag, T extends IValueType<V>, V extends IValue>
    extends ValueTypeListProxyNBTFactorySimple<T, V, L> {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("integrateddynamics", "nbt.list_value");
        }

        @Override
        protected void serializeNbt(L value, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            tag.putString("key", ((ValueTypeListProxyNbtValueListGeneric)value).getKey());
            if (((ValueTypeListProxyNbtValueListGeneric)value).getTag().isPresent()) {
                tag.put("tag", (Tag)((ValueTypeListProxyNbtValueListGeneric)value).getTag().get());
            }
        }

        @Override
        protected L deserializeNbt(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) throws IValueTypeListProxyFactoryTypeRegistry.SerializationException {
            return this.create(tag.getString("key"), Optional.ofNullable(tag.get("tag")));
        }

        protected abstract L create(String var1, Optional<Tag> var2);
    }
}

