/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeOperatorLPElement;

public class ValueTypeOperator
extends ValueTypeBase<ValueOperator>
implements IValueTypeNamed<ValueOperator>,
IValueTypeUniquelyNamed<ValueOperator> {
    private static final String SIGNATURE_LINK = "->";

    public ValueTypeOperator() {
        super("operator", Helpers.RGBToInt((int)43, (int)231, (int)47), ChatFormatting.DARK_GREEN, ValueOperator.class);
    }

    @Override
    public ValueOperator getDefault() {
        return ValueOperator.of(Operators.GENERAL_IDENTITY);
    }

    @Override
    public MutableComponent toCompactString(ValueOperator value) {
        return value.getRawValue().getLocalizedNameFull();
    }

    @Override
    public Tag serialize(ValueOperator value) {
        return Operators.REGISTRY.serialize(value.getRawValue());
    }

    @Override
    public ValueOperator deserialize(ValueDeseralizationContext valueDeseralizationContext, Tag value) {
        IOperator operator;
        try {
            operator = Operators.REGISTRY.deserialize(valueDeseralizationContext, value);
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (operator != null) {
            return ValueOperator.of(operator);
        }
        throw new IllegalArgumentException(String.format("Value \"%s\" could not be parsed to an operator.", value));
    }

    @Override
    public void loadTooltip(List<Component> lines, boolean appendOptionalInfo, @Nullable ValueOperator value) {
        super.loadTooltip(lines, appendOptionalInfo, value);
        if (value != null) {
            lines.add((Component)Component.translatable((String)"valuetype.integrateddynamics.operator.tooltip.signature").append((Component)ValueTypeOperator.getSignature(value.getRawValue())));
        }
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeOperatorLPElement();
    }

    @Override
    public ValueOperator materialize(ValueOperator value) throws EvaluationException {
        return ValueOperator.of(value.getRawValue().materialize());
    }

    public static MutableComponent getSignature(IOperator operator) {
        return ValueTypeOperator.getSignatureLines(operator, false).stream().reduce(Component.literal((String)""), (a, b) -> a.append(" ").append((Component)b));
    }

    public static Component getSignature(IValueType[] inputTypes, IValueType outputType) {
        return (Component)ValueTypeOperator.getSignatureLines(inputTypes, outputType, false).stream().reduce((prev, next) -> prev.append(" ").append((Component)next)).orElseGet(() -> Component.literal((String)""));
    }

    protected static MutableComponent switchSignatureLineContext(List<MutableComponent> lines, MutableComponent sb) {
        lines.add(sb);
        return Component.literal((String)"");
    }

    public static List<MutableComponent> getSignatureLines(IValueType[] inputTypes, IValueType outputType, boolean indent) {
        ArrayList lines = Lists.newArrayList();
        MutableComponent sb = Component.literal((String)"");
        boolean first = true;
        for (IValueType inputType : inputTypes) {
            if (first) {
                first = false;
            } else {
                sb = ValueTypeOperator.switchSignatureLineContext(lines, sb);
                sb.append((indent ? "  " : "") + "-> ");
            }
            sb = sb.append((Component)Component.translatable((String)inputType.getTranslationKey()).withStyle(inputType.getDisplayColorFormat()));
        }
        sb = ValueTypeOperator.switchSignatureLineContext(lines, sb);
        sb = sb.append((indent ? "  " : "") + "-> ").append((Component)Component.translatable((String)outputType.getTranslationKey()).withStyle(outputType.getDisplayColorFormat()));
        ValueTypeOperator.switchSignatureLineContext(lines, sb);
        return lines;
    }

    public static List<MutableComponent> getSignatureLines(IOperator operator, boolean indent) {
        return ValueTypeOperator.getSignatureLines(operator.getInputTypes(), operator.getOutputType(), indent);
    }

    @Override
    public String getName(ValueOperator a) {
        return a.getRawValue().getLocalizedNameFull().getString();
    }

    @Override
    public String getUniqueName(ValueOperator a) {
        return a.getRawValue().getUniqueName().toString();
    }

    public static class ValueOperator
    extends ValueBase {
        private final IOperator value;

        private ValueOperator(IOperator value) {
            super(ValueTypes.OPERATOR);
            this.value = value;
        }

        public static ValueOperator of(IOperator value) {
            return new ValueOperator(value);
        }

        public IOperator getRawValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ValueOperator && this.value.equals(((ValueOperator)o).value);
        }

        public int hashCode() {
            return 37 + this.value.hashCode();
        }

        @Override
        public String toString() {
            return "ValueTypeOperator.ValueOperator(value=" + this.value + ")";
        }
    }

    public static class ValueOperatorPredicate
    extends ValuePredicate<ValueOperator> {
        private final Optional<IOperator> operator;

        public ValueOperatorPredicate(Optional<IOperator> operator) {
            super(Optional.of(ValueTypes.OPERATOR), Optional.empty(), Optional.empty());
            this.operator = operator;
        }

        public Optional<IOperator> getOperator() {
            return this.operator;
        }

        @Override
        protected boolean testTyped(ValueOperator value) {
            return super.testTyped(value) && (this.operator.isEmpty() || value.getRawValue() == this.operator.get());
        }
    }
}

