/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.advancement.criterion.ValuePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariableFacadePredicate;
import org.cyclops.integrateddynamics.api.advancement.criterion.VariablePredicate;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorRegistry;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeRegistry;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.evaluate.variable.VariableFacadePredicateTyped;
import org.cyclops.integrateddynamics.core.evaluate.variable.VariablePredicateTyped;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class Codecs {
    public static final Codec<IPartType> PART_TYPE = Codec.STRING.xmap(name -> {
        IPartType partType = PartTypes.REGISTRY.getPartType(new ResourceLocation(name));
        if (partType == null) {
            throw new JsonSyntaxException("No part type found with name: " + name);
        }
        return partType;
    }, partType -> partType.getUniqueName().toString());
    public static final Codec<IAspect> ASPECT = Codec.STRING.xmap(name -> {
        IAspect aspect = Aspects.REGISTRY.getAspect(new ResourceLocation(name));
        if (aspect == null) {
            throw new JsonSyntaxException("No aspect found with name: " + name);
        }
        return aspect;
    }, aspect -> aspect.getUniqueName().toString());
    public static final Codec<IOperator> OPERATOR = Codec.STRING.xmap(name -> {
        IOperator operator = Operators.REGISTRY.getOperator(new ResourceLocation(name));
        if (operator == null) {
            throw new JsonSyntaxException("No operator found with name: " + name);
        }
        return operator;
    }, operator -> operator.getUniqueName().toString());
    public static final Codec<IValueType> VALUE_TYPE = Codec.STRING.xmap(name -> {
        IValueType valueType = ValueTypes.REGISTRY.getValueType(new ResourceLocation(name));
        if (valueType == null) {
            throw new JsonSyntaxException("Unknown value type '" + name + "', valid types are: " + ValueTypes.REGISTRY.getValueTypes().stream().map(IValueType::getUniqueName).collect(Collectors.toList()));
        }
        return valueType;
    }, valueType -> valueType.getUniqueName().toString());
    public static final Codec<EntityType<? extends Entity>> ENTITY_TYPE = Codec.STRING.xmap(name -> {
        try {
            return (EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation(name));
        }
        catch (ResourceLocationException e) {
            throw new JsonSyntaxException("Invalid entity type name '" + name + "'");
        }
    }, entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString());
    public static final Codec<ValuePredicate> VALUE = Codecs.xorCommonList(Arrays.asList(RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("operator"), (App)ExtraCodecs.strictOptionalField(OPERATOR, (String)"operator").forGetter(ValueTypeOperator.ValueOperatorPredicate::getOperator)).apply((Applicative)builder, (type, operator) -> new ValueTypeOperator.ValueOperatorPredicate((Optional<IOperator>)operator))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("itemstack"), (App)ExtraCodecs.strictOptionalField((Codec)ItemPredicate.CODEC, (String)"item").forGetter(ValueObjectTypeItemStack.ValueItemStackPredicate::getItemPredicate)).apply((Applicative)builder, (type, itemPredicate) -> new ValueObjectTypeItemStack.ValueItemStackPredicate((Optional<ItemPredicate>)itemPredicate))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("entity"), (App)ExtraCodecs.strictOptionalField(ENTITY_TYPE, (String)"entity").forGetter(ValueObjectTypeEntity.ValueEntityPredicate::getEntityType)).apply((Applicative)builder, (type, entityType) -> new ValueObjectTypeEntity.ValueEntityPredicate((Optional<EntityType<? extends Entity>>)entityType))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("list"), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"infinite_list").forGetter(ValueTypeList.ValueListPredicate::getInfinite)).apply((Applicative)builder, (type, infinite) -> new ValueTypeList.ValueListPredicate((Optional<Boolean>)infinite))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("serialized"), (App)VALUE_TYPE.fieldOf("value_type").forGetter(v -> v.getValueType().get()), (App)ExtraCodecs.FLAT_JSON.fieldOf("value").forGetter(v -> v.getValueJson().get())).apply((Applicative)builder, (raw, valueType, valueJson) -> {
        Optional<IValue> value = Optional.empty();
        try {
            CompoundTag tag = TagParser.parseTag((String)valueJson.toString());
            if (tag.contains("Primitive")) {
                tag = tag.get("Primitive");
            }
            value = Optional.of(ValueHelpers.deserializeRaw(ValueDeseralizationContext.ofAllEnabled(), valueType, (Tag)tag));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        return new ValuePredicate(Optional.of(valueType), value, Optional.of(valueJson));
    }))));
    public static final Codec<VariablePredicate> VARIABLE = Codecs.getVariableCodec();
    public static final Codec<VariableFacadePredicate> VARIABLE_FACADE = Codecs.xorCommonList(Arrays.asList(RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("aspect"), (App)ExtraCodecs.strictOptionalField(ASPECT, (String)"aspect").forGetter(AspectRegistry.AspectVariableFacadePredicate::getAspect)).apply((Applicative)builder, (type, aspect) -> new AspectRegistry.AspectVariableFacadePredicate((Optional<IAspect>)aspect))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("value_type"), (App)ExtraCodecs.strictOptionalField(VALUE_TYPE, (String)"value_type").forGetter(ValueTypeRegistry.ValueTypeVariableFacadePredicate::getValueType), (App)ExtraCodecs.strictOptionalField(VALUE, (String)"value").forGetter(ValueTypeRegistry.ValueTypeVariableFacadePredicate::getValuePredicate)).apply((Applicative)builder, (type, valueType, value) -> new ValueTypeRegistry.ValueTypeVariableFacadePredicate((Optional<IValueType>)valueType, (Optional<ValuePredicate>)value))), RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.validate((Codec)Codec.STRING, type -> ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandler(new ResourceLocation(type)) == null ? DataResult.error(() -> "Variable facade predicate is expected to have as 'type' one of: " + String.join((CharSequence)", ", ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandlerNames())) : DataResult.success((Object)type)).fieldOf("type").forGetter(p -> p.getHandler().getUniqueName().toString())).apply((Applicative)builder, type -> new VariableFacadePredicateTyped(((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandler(new ResourceLocation(type))))), Codec.unit(new VariableFacadePredicate<IVariableFacade>(IVariableFacade.class))));

    public static Codec<VariablePredicate> getVariableCodec() {
        return Codecs.xorCommonList(Arrays.asList(RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("operator"), (App)ExtraCodecs.strictOptionalField(VALUE_TYPE, (String)"value_type").forGetter(VariablePredicate::getValueType), (App)ExtraCodecs.strictOptionalField(VALUE, (String)"value").forGetter(VariablePredicate::getValuePredicate), (App)ExtraCodecs.strictOptionalField(OPERATOR, (String)"operator").forGetter(OperatorRegistry.OperatorVariablePredicate::getOperator), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.strictUnboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, integer -> Integer.toString(integer)), (Codec)ExtraCodecs.lazyInitializedCodec(Codecs::getVariableCodec)), (String)"input").forGetter(OperatorRegistry.OperatorVariablePredicate::getInputPredicates)).apply((Applicative)builder, (type, valueType, value, operator, input) -> new OperatorRegistry.OperatorVariablePredicate((Optional<IValueType>)valueType, (Optional<ValuePredicate>)value, (Optional<IOperator>)operator, (Optional<Map<Integer, VariablePredicate>>)input))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("aspect"), (App)ExtraCodecs.strictOptionalField(VALUE_TYPE, (String)"value_type").forGetter(VariablePredicate::getValueType), (App)ExtraCodecs.strictOptionalField(VALUE, (String)"value").forGetter(VariablePredicate::getValuePredicate), (App)ExtraCodecs.strictOptionalField(ASPECT, (String)"aspect").forGetter(AspectRegistry.AspectVariablePredicate::getAspect)).apply((Applicative)builder, (type, valueType, value, aspect) -> new AspectRegistry.AspectVariablePredicate((Optional<IValueType>)valueType, (Optional<ValuePredicate>)value, (Optional<IAspect>)aspect))), RecordCodecBuilder.create(builder -> builder.group(Codecs.staticTypeField("value_type"), (App)ExtraCodecs.strictOptionalField(VALUE_TYPE, (String)"value_type").forGetter(VariablePredicate::getValueType), (App)ExtraCodecs.strictOptionalField(VALUE, (String)"value").forGetter(VariablePredicate::getValuePredicate)).apply((Applicative)builder, (type, valueType, valuePredicate) -> new VariablePredicate<IVariable>(IVariable.class, (Optional<IValueType>)valueType, (Optional<ValuePredicate>)valuePredicate))), RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.validate((Codec)Codec.STRING, type -> ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandler(new ResourceLocation(type)) == null ? DataResult.error(() -> "Variable facade predicate is expected to have as 'type' one of: " + String.join((CharSequence)", ", ((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandlerNames())) : DataResult.success((Object)type)).fieldOf("type").forGetter(p -> p.getHandler().getUniqueName().toString()), (App)ExtraCodecs.strictOptionalField(VALUE_TYPE, (String)"value_type").forGetter(VariablePredicate::getValueType), (App)ExtraCodecs.strictOptionalField(VALUE, (String)"value").forGetter(VariablePredicate::getValuePredicate)).apply((Applicative)builder, (type, valueType, valuePredicate) -> new VariablePredicateTyped(((IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class)).getHandler(new ResourceLocation(type)), (Optional<IValueType>)valueType, (Optional<ValuePredicate>)valuePredicate)))));
    }

    public static <T> RecordCodecBuilder<T, String> staticTypeField(String value) {
        return ExtraCodecs.validate((Codec)Codec.STRING, type -> !value.equals(type) ? DataResult.error(() -> "Variable facade predicate is expected to have 'type': '" + value + "'") : DataResult.success((Object)type)).fieldOf("type").forGetter(p -> value);
    }

    public static <X> Codec<X> xorCommonList(List<Codec<? extends X>> codecs) {
        Codec<X> codec = codecs.get(0);
        for (Codec<X> codec2 : codecs.subList(1, codecs.size())) {
            codec = Codecs.xorCommon(codec, codec2);
        }
        return codec;
    }

    public static <X, F extends X, S extends X> Codec<X> xorCommon(Codec<F> p_144640_, Codec<S> p_144641_) {
        return new XorCodecCommon(p_144640_, p_144641_);
    }

    record XorCodecCommon<X, F extends X, S extends X>(Codec<F> first, Codec<S> second) implements Codec<X>
    {
        public <T> DataResult<Pair<X, T>> decode(DynamicOps<T> p_144679_, T p_144680_) {
            DataResult dataresult = this.first.decode(p_144679_, p_144680_).map(p_144673_ -> p_144673_);
            DataResult dataresult1 = this.second.decode(p_144679_, p_144680_).map(p_144673_ -> p_144673_);
            Optional optional = dataresult.result();
            Optional optional1 = dataresult1.result();
            if (optional.isPresent() && optional1.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + optional.get() + " second: " + optional1.get(), (Object)((Pair)optional.get()));
            }
            if (optional.isPresent()) {
                return dataresult;
            }
            return optional1.isPresent() ? dataresult1 : dataresult.apply2((p_300790_, p_300791_) -> p_300791_, dataresult1);
        }

        public <T> DataResult<T> encode(X p_144663_, DynamicOps<T> p_144664_, T p_144665_) {
            try {
                return this.first.encode(p_144663_, p_144664_, p_144665_);
            }
            catch (ClassCastException e) {
                return this.second.encode(p_144663_, p_144664_, p_144665_);
            }
        }

        @Override
        public String toString() {
            return "XorCodecCommon[" + this.first + ", " + this.second + "]";
        }
    }
}

