/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.UnknownPartEvent;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;
import org.cyclops.integrateddynamics.core.part.PartTypeRegistry;
import org.cyclops.integrateddynamics.core.part.PartTypes;

public class PartHelpers {
    public static Optional<IPartContainer> getPartContainer(ILevelExtension world, BlockPos pos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((ILevelExtension)world, (BlockPos)pos, (Object)side, Capabilities.PartContainer.BLOCK);
    }

    public static Optional<IPartContainer> getPartContainer(DimPos dimPos, @Nullable Direction side) {
        return BlockEntityHelpers.getCapability((DimPos)dimPos, (Object)side, Capabilities.PartContainer.BLOCK);
    }

    public static IPartContainer getPartContainerChecked(Level world, BlockPos pos, @Nullable Direction side) {
        return PartHelpers.getPartContainer((ILevelExtension)world, pos, side).orElseThrow(() -> new PartStateException(DimPos.of((Level)world, (BlockPos)pos), side));
    }

    public static IPartContainer getPartContainerChecked(DimPos dimPos, @Nullable Direction side) {
        return PartHelpers.getPartContainer(dimPos, side).orElseThrow(() -> new PartStateException(dimPos, side));
    }

    public static IPartContainer getPartContainerChecked(PartPos pos) {
        return PartHelpers.getPartContainerChecked(pos.getPos(), pos.getSide());
    }

    public static IPartType validatePartType(INetwork network, String partTypeName, @Nullable IPartType partType) {
        if (network != null && partType == null) {
            UnknownPartEvent event = new UnknownPartEvent(network, partTypeName);
            network.getEventBus().post(event);
            partType = event.getPartType();
        }
        return partType;
    }

    public static void writePartTypeToNBT(CompoundTag partTag, Direction side, IPartType partType) {
        partTag.putString("__partType", partType.getUniqueName().toString());
        partTag.putString("__side", side.getSerializedName());
    }

    public static boolean writePartToNBT(BlockPos pos, CompoundTag partTag, Pair<Direction, PartStateHolder<?, ?>> partData) {
        IPartType part = ((PartStateHolder)partData.getValue()).getPart();
        Object partState = ((PartStateHolder)partData.getValue()).getState();
        PartHelpers.writePartTypeToNBT(partTag, (Direction)partData.getKey(), part);
        try {
            part.toNBT(partTag, partState);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, String.format("The part %s at position %s was errored and is removed.", part.getUniqueName(), pos));
            return false;
        }
    }

    public static void writePartsToNBT(BlockPos pos, CompoundTag tag, Map<Direction, PartStateHolder<?, ?>> partData) {
        ListTag partList = new ListTag();
        Iterator<Map.Entry<Direction, PartStateHolder<?, ?>>> iterator = partData.entrySet().iterator();
        while (iterator.hasNext()) {
            CompoundTag partTag = new CompoundTag();
            Map.Entry<Direction, PartStateHolder<?, ?>> entry = iterator.next();
            if (!PartHelpers.writePartToNBT(pos, partTag, Pair.of((Object)entry.getKey(), entry.getValue()))) continue;
            partList.add((Object)partTag);
        }
        tag.put("parts", (Tag)partList);
    }

    public static Pair<Direction, IPartType> readPartTypeFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag partTag) {
        String partTypeName = partTag.getString("__partType");
        IPartType partType = PartHelpers.validatePartType(network, partTypeName, PartTypes.REGISTRY.getPartType(new ResourceLocation(partTypeName)));
        if (partType != null) {
            Direction side = Direction.byName((String)partTag.getString("__side"));
            if (side != null) {
                return Pair.of((Object)side, (Object)partType);
            }
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was at an invalid side and removed.", partType.getUniqueName(), pos));
        } else {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part %s at position %s was unknown and removed.", partTypeName, pos));
        }
        return null;
    }

    public static Pair<Direction, ? extends PartStateHolder<?, ?>> readPartFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag partTag, Level level) {
        Pair<Direction, IPartType> partData = PartHelpers.readPartTypeFromNBT(network, pos, partTag);
        if (partData != null) {
            Object partState = ((IPartType)partData.getValue()).fromNBT(ValueDeseralizationContext.of(level), partTag);
            return Pair.of((Object)((Direction)partData.getKey()), PartStateHolder.of((IPartType)partData.getValue(), partState));
        }
        return null;
    }

    public static void readPartsFromNBT(@Nullable INetwork network, BlockPos pos, CompoundTag tag, Map<Direction, PartStateHolder<?, ?>> partData, Level world) {
        ImmutableMap oldPartData = ImmutableMap.copyOf(partData);
        partData.clear();
        ListTag partList = tag.getList("parts", 10);
        for (int i = 0; i < partList.size(); ++i) {
            CompoundTag partTag = partList.getCompound(i);
            Pair<Direction, ? extends PartStateHolder<?, ?>> part = PartHelpers.readPartFromNBT(network, pos, partTag, world);
            if (part == null) continue;
            partData.put((Direction)part.getKey(), (PartStateHolder)part.getValue());
        }
        if (world != null && world.isClientSide()) {
            boolean triggerBlockRenderUpdate = false;
            for (Direction side : Direction.values()) {
                Object newPartState;
                PartStateHolder oldData = (PartStateHolder)oldPartData.get(side);
                PartStateHolder<?, ?> newData = partData.get(side);
                if (oldData == null && newData == null) continue;
                IPartType oldPartType = oldData != null ? oldData.getPart() : null;
                IPartType<?, ?> newPartType = newData != null ? newData.getPart() : null;
                Object oldPartState = oldData != null ? (Object)oldData.getState() : null;
                Object s = newPartState = newData != null ? (Object)newData.getState() : null;
                if (oldPartType == newPartType && !oldPartType.shouldTriggerBlockRenderUpdate(oldPartState, newPartState)) continue;
                triggerBlockRenderUpdate = true;
                break;
            }
            if (triggerBlockRenderUpdate) {
                BlockHelpers.markForUpdate((Level)world, (BlockPos)pos);
            }
        }
    }

    public static boolean removePart(Level world, BlockPos pos, Direction side, @Nullable Player player, boolean destroyIfEmpty, boolean dropMainElement, boolean saveState) {
        boolean removeCompletely;
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
        ICableFakeable cableFakeable = CableHelpers.getCableFakeable((ILevelExtension)world, pos, side).orElse(null);
        partContainer.removePart(side, player, dropMainElement, saveState);
        boolean bl = removeCompletely = destroyIfEmpty && (cableFakeable == null || !cableFakeable.isRealCable()) && !partContainer.hasParts();
        if (removeCompletely) {
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            world.updateNeighborsAt(pos, world.getBlockState(pos).getBlock());
            if (CableHelpers.getCable((ILevelExtension)world, pos.relative(side), side.getOpposite()).isPresent()) {
                CableHelpers.updateConnections((ILevelExtension)world, pos, side);
                CableHelpers.updateConnections((ILevelExtension)world, pos.relative(side), side.getOpposite());
                NetworkHelpers.initNetwork((ILevelExtension)world, pos, side);
            }
        }
        return !removeCompletely;
    }

    public static boolean addPart(Level level, BlockPos pos, Direction side, IPartType partType, ItemStack itemStack) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(level, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!level.isClientSide()) {
                partContainer.setPart(side, partType, partType.getState(ValueDeseralizationContext.of(level), itemStack));
            }
            return true;
        }
        return false;
    }

    public static boolean addPart(Level world, BlockPos pos, Direction side, IPartType partType, IPartState partState) {
        IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
        if (partContainer.canAddPart(side, partType)) {
            if (!world.isClientSide()) {
                partContainer.setPart(side, partType, partState);
            }
            return true;
        }
        return false;
    }

    public static boolean setPart(@Nullable INetwork network, Level world, BlockPos pos, Direction side, IPartType part, IPartState partState, IPartStateHolderCallback callback) {
        callback.onSet(PartStateHolder.of(part, partState));
        if (network != null) {
            IPartContainer partContainer = PartHelpers.getPartContainerChecked(world, pos, side);
            INetworkElement networkElement = part.createNetworkElement(partContainer, DimPos.of((Level)world, (BlockPos)pos), side);
            if (!network.addNetworkElement(networkElement, false)) {
                partState = part.defaultBlockState();
                callback.onSet(PartStateHolder.of(part, partState));
                IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, "A part already existed in the network, this is possibly a result from item duplication.");
                network.addNetworkElement(networkElement, false);
            }
            return true;
        }
        return false;
    }

    public static boolean canInteractWith(PartTarget target, Player player, IPartContainer expectedPartContainer) {
        IPartContainer partContainer = PartHelpers.getPartContainer(target.getCenter().getPos(), target.getCenter().getSide()).orElse(null);
        return partContainer == expectedPartContainer;
    }

    @Nullable
    public static PartStateHolder<?, ?> getPart(PartPos partPos) {
        Direction side = partPos.getSide();
        IPartContainer partContainer = PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide()).orElse(null);
        if (partContainer != null && partContainer.hasPart(side)) {
            return PartStateHolder.of(partContainer.getPart(side), partContainer.getPartState(side));
        }
        return null;
    }

    public static InteractionResult openContainerPart(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProvider(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiData((FriendlyByteBuf)packetBuffer, pos, player));
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    public static boolean openContainerPartSettings(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderSettings(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiDataSettings((FriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static void openContainerAspectSettings(ServerPlayer player, PartPos pos, IAspect<?, ?> aspect) {
        player.openMenu(aspect.getPropertiesContainerProvider(pos), packetBuffer -> packetBuffer.writeUtf(aspect.getUniqueName().toString()));
    }

    public static boolean openContainerPartOffsets(ServerPlayer player, PartPos pos, IPartType<?, ?> partType) {
        return partType.getContainerProviderOffsets(pos).map(containerProvider -> {
            player.openMenu(containerProvider, packetBuffer -> partType.writeExtraGuiDataOffsets((FriendlyByteBuf)packetBuffer, pos, player));
            return true;
        }).orElse(false);
    }

    public static Triple<IPartContainer, PartTypeBase, PartTarget> getContainerPartConstructionData(PartPos pos) {
        IPartContainer partContainer = PartHelpers.getPartContainer(pos.getPos(), pos.getSide()).orElse(null);
        if (partContainer == null) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The tile at %s is not a valid part container.", pos));
            return null;
        }
        IPartType partType = partContainer.getPart(pos.getSide());
        if (partType == null || !(partType instanceof PartTypeBase)) {
            IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("The part container at %s side %s does not have a valid part.", pos, pos.getSide()));
            return null;
        }
        PartTarget target = partType.getTarget(pos, partContainer.getPartState(pos.getSide()));
        return Triple.of((Object)partContainer, (Object)((PartTypeBase)partType), (Object)target);
    }

    public static PartTarget readPartTarget(FriendlyByteBuf packetBuffer) {
        return PartTarget.fromCenter((PartPos)PacketCodec.read((FriendlyByteBuf)packetBuffer, PartPos.class));
    }

    public static <P extends IPartType<P, S>, S extends IPartState<P>> P readPart(FriendlyByteBuf packetBuffer) {
        String name = packetBuffer.readUtf();
        return (P)Objects.requireNonNull(PartTypeRegistry.getInstance().getPartType(new ResourceLocation(name)), String.format("Could not find a part by name %s", name));
    }

    public static class PartStateHolder<P extends IPartType<P, S>, S extends IPartState<P>> {
        private final IPartType<P, S> part;
        private final S state;

        public static PartStateHolder<?, ?> of(IPartType part, IPartState partState) {
            return new PartStateHolder(part, partState);
        }

        public PartStateHolder(IPartType<P, S> part, S state) {
            this.part = part;
            this.state = state;
        }

        public IPartType<P, S> getPart() {
            return this.part;
        }

        public S getState() {
            return this.state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartStateHolder)) {
                return false;
            }
            PartStateHolder other = (PartStateHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPartType<P, S> this$part = this.getPart();
            IPartType<P, S> other$part = other.getPart();
            if (this$part == null ? other$part != null : !this$part.equals(other$part)) {
                return false;
            }
            S this$state = this.getState();
            S other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PartStateHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPartType<P, S> $part = this.getPart();
            result = result * 59 + ($part == null ? 43 : $part.hashCode());
            S $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "PartHelpers.PartStateHolder(part=" + this.getPart() + ", state=" + this.getState() + ")";
        }
    }

    public static interface IPartStateHolderCallback {
        public void onSet(PartStateHolder<?, ?> var1);
    }
}

