/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.slot.SlotVariable;

public class ContainerPartOffset
extends InventoryContainer {
    public static final String BUTTON_SAVE = "button_save";
    private final PartTarget target;
    private final Optional<IPartContainer> partContainer;
    private final IPartType partType;
    private final Level world;
    private final int lastXValueId;
    private final int lastYValueId;
    private final int lastZValueId;
    private final List<Integer> offsetVariableSlotErrorIds;
    private final List<Integer> offsetVariableSlotFilled;
    private final int maxOffsetId;
    private final SimpleInventory offsetVariablesInventory;
    private boolean dirtyInv = false;

    public ContainerPartOffset(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(0), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartType)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartOffset(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        this((MenuType)RegistryEntries.CONTAINER_PART_OFFSET.get(), id, playerInventory, inventory, target, partContainer, partType);
    }

    public ContainerPartOffset(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        super(type, id, playerInventory, inventory);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = this.player.getCommandSenderWorld();
        this.addPlayerInventory(this.player.getInventory(), 27, this.getPlayerInventoryOffsetY());
        this.lastXValueId = this.getNextValueId();
        this.lastYValueId = this.getNextValueId();
        this.lastZValueId = this.getNextValueId();
        this.offsetVariableSlotErrorIds = Lists.newArrayList();
        this.offsetVariableSlotFilled = Lists.newArrayList();
        for (int i = 0; i < 3; ++i) {
            this.offsetVariableSlotErrorIds.add(this.getNextValueId());
            this.offsetVariableSlotFilled.add(this.getNextValueId());
        }
        this.maxOffsetId = this.getNextValueId();
        this.putButtonAction(BUTTON_SAVE, (s, containerExtended) -> {
            if (!this.world.isClientSide()) {
                PartHelpers.openContainerPart((ServerPlayer)this.player, target.getCenter(), this.getPartType());
            }
        });
        this.offsetVariablesInventory = new SimpleInventory(3, 1);
        this.offsetVariablesInventory.addDirtyMarkListener(() -> {
            this.dirtyInv = true;
        });
        if (!this.player.level().isClientSide) {
            this.getPartState().loadInventoryNamed("offsetVariablesInventory", (Container)this.offsetVariablesInventory);
        }
        this.addSlot((Slot)new SlotVariable((Container)this.offsetVariablesInventory, 0, 45, 51));
        this.addSlot((Slot)new SlotVariable((Container)this.offsetVariablesInventory, 1, 99, 51));
        this.addSlot((Slot)new SlotVariable((Container)this.offsetVariablesInventory, 2, 153, 51));
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public int getLastXValueId() {
        return this.lastXValueId;
    }

    public int getLastYValueId() {
        return this.lastYValueId;
    }

    public int getLastZValueId() {
        return this.lastZValueId;
    }

    public int getMaxOffsetId() {
        return this.maxOffsetId;
    }

    protected int getPlayerInventoryOffsetY() {
        return 73;
    }

    protected void initializeValues() {
        Vec3i offset = this.getPartType().getTargetOffset(this.getPartState());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXValueId, (int)offset.getX());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYValueId, (int)offset.getY());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZValueId, (int)offset.getZ());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.maxOffsetId, (int)this.getPartState().getMaxOffset());
    }

    public int getLastXValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastXValueId);
    }

    public int getLastYValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastYValueId);
    }

    public int getLastZValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastZValueId);
    }

    public int getMaxOffset() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.maxOffsetId);
    }

    public IPartState getPartState() {
        return this.partContainer.get().getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean stillValid(Player player) {
        return PartHelpers.canInteractWith(this.getTarget(), player, this.partContainer.get());
    }

    protected int getSizeInventory() {
        return 0;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        try {
            if (!this.world.isClientSide()) {
                this.updatePartOffset();
            }
        }
        catch (PartStateException e) {
            this.player.closeContainer();
        }
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (!this.player.level().isClientSide) {
            IPartState partState = this.getPartState();
            if (this.dirtyInv) {
                this.dirtyInv = false;
                partState.saveInventoryNamed("offsetVariablesInventory", (Container)this.offsetVariablesInventory);
                this.getPartType().onOffsetVariablesChanged(this.getTarget(), partState);
            }
            for (int i = 0; i < 3; ++i) {
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.offsetVariableSlotErrorIds.get(i), (MutableComponent)partState.getOffsetVariableError(i));
                ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.offsetVariableSlotFilled.get(i), (!this.offsetVariablesInventory.getItem(i).isEmpty() ? 1 : 0) != 0);
            }
            Vec3i offset = this.getPartType().getTargetOffset(this.getPartState());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastXValueId, (int)offset.getX());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastYValueId, (int)offset.getY());
            ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastZValueId, (int)offset.getZ());
        }
    }

    @Nullable
    public Component getOffsetVariableError(int slot) {
        return ValueNotifierHelpers.getValueTextComponent((IValueNotifier)this, (int)this.offsetVariableSlotErrorIds.get(slot));
    }

    public boolean isOffsetVariableFilled(int slot) {
        return ValueNotifierHelpers.getValueBoolean((IValueNotifier)this, (int)this.offsetVariableSlotFilled.get(slot));
    }

    protected void updatePartOffset() {
        Vec3i offset = new Vec3i(this.getLastXValue(), this.getLastYValue(), this.getLastZValue());
        this.getPartType().setTargetOffset(this.getPartState(), this.getTarget().getCenter(), offset);
    }
}

