/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class ItemBlockEnergyContainerAutoSupply
extends ItemBlockEnergyContainer {
    public ItemBlockEnergyContainerAutoSupply(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, world, list, flag);
        L10NHelpers.addStatusInfo(list, (boolean)this.isActivated(itemStack), (String)(this.getDescriptionId() + ".info.auto_supply"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)this.toggleActivation(player.getItemInHand(hand), world, player));
    }

    public static void autofill(IEnergyStorage source, Level world, Entity entity) {
        int tickAmount;
        if (entity instanceof Player && !world.isClientSide() && (tickAmount = source.extractEnergy(Integer.MAX_VALUE, true)) > 0) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.getItemInHand(hand);
                ItemStack filled = ItemBlockEnergyContainerAutoSupply.tryFillContainerForPlayer(source, held, tickAmount, player);
                if (filled.isEmpty()) continue;
                player.setItemInHand(hand, filled);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(IEnergyStorage source, ItemStack held, int tickAmount, Player player) {
        int moved;
        IEnergyStorage target = (IEnergyStorage)held.getCapability(Capabilities.EnergyStorage.ITEM, null);
        if (target != null && (moved = target.receiveEnergy(source.extractEnergy(target.receiveEnergy(tickAmount, true), false), false)) > 0) {
            return held;
        }
        return ItemStack.EMPTY;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean par5) {
        IEnergyStorage energyStorage;
        if (this.isActivated(itemStack) && (energyStorage = (IEnergyStorage)itemStack.getCapability(Capabilities.EnergyStorage.ITEM, null)) != null) {
            ItemBlockEnergyContainerAutoSupply.autofill(energyStorage, world, entity);
        }
        super.inventoryTick(itemStack, world, entity, itemSlot, par5);
    }

    public ItemStack toggleActivation(ItemStack itemStack, Level world, Player player) {
        if (player.isSecondaryUseActive()) {
            if (!world.isClientSide()) {
                ItemStack activated = itemStack.copy();
                activated.setDamageValue(1 - activated.getDamageValue());
                return activated;
            }
            return itemStack;
        }
        return itemStack;
    }

    public boolean isActivated(ItemStack itemStack) {
        return itemStack.getDamageValue() == 1;
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.isActivated(itemStack);
    }
}

