/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.CompositeMap;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IVariableContainer;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.FullNetworkListenerAdapter;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.api.part.read.IPartStateReader;
import org.cyclops.integrateddynamics.api.part.read.IPartTypeReader;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;

public class PartNetwork
extends FullNetworkListenerAdapter
implements IPartNetwork {
    private INetwork network;
    private Int2ObjectMap<PartPos> partPositions = new Int2ObjectOpenHashMap();
    private List<DimPos> variableContainerPositions = Lists.newArrayList();
    private Map<Integer, IVariableFacade> compositeVariableCache = null;
    private Int2ObjectMap<IValue> lazyExpressionValueCache = new Int2ObjectOpenHashMap();
    private Int2ObjectMap<DimPos> proxyPositions = new Int2ObjectOpenHashMap();
    private volatile boolean partsChanged = false;

    @Override
    public boolean addPart(int partId, PartPos partPos) {
        if (this.partPositions.containsKey(partId)) {
            return false;
        }
        this.compositeVariableCache = null;
        this.partPositions.put(partId, (Object)partPos);
        return true;
    }

    @Override
    public IPartState getPartState(int partId) {
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        return PartHelpers.getPartContainerChecked(partPos.getPos(), partPos.getSide()).getPartState(partPos.getSide());
    }

    @Override
    public IPartType getPartType(int partId) {
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        return PartHelpers.getPartContainerChecked(partPos.getPos(), partPos.getSide()).getPart(partPos.getSide());
    }

    @Override
    public void removePart(int partId) {
        this.compositeVariableCache = null;
        this.partPositions.remove(partId);
    }

    @Override
    public boolean hasPart(int partId) {
        if (!this.partPositions.containsKey(partId)) {
            return false;
        }
        PartPos partPos = (PartPos)this.partPositions.get(partId);
        return PartHelpers.getPartContainer(partPos.getPos(), partPos.getSide()).map(partContainer -> partContainer.hasPart(partPos.getSide())).orElse(false);
    }

    @Override
    public <V extends IValue> boolean hasPartVariable(int partId, IAspectRead<V, ?> aspect) {
        if (!this.hasPart(partId)) {
            return false;
        }
        IPartState partState = this.getPartState(partId);
        if (!(partState instanceof IPartStateReader)) {
            return false;
        }
        IPartType partType = this.getPartType(partId);
        if (!(partType instanceof IPartTypeReader)) {
            return false;
        }
        try {
            return ((IPartTypeReader)partType).getVariable(partType.getTarget((PartPos)this.partPositions.get(partId), partState), (IPartStateReader)partState, aspect) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public <V extends IValue> IVariable<V> getPartVariable(int partId, IAspectRead<V, ?> aspect) {
        return ((IPartStateReader)this.getPartState(partId)).getVariable(aspect);
    }

    protected Map<Integer, IVariableFacade> getVariableCache() {
        if (this.compositeVariableCache == null) {
            CompositeMap compositeMap = new CompositeMap();
            Iterator<DimPos> it = this.variableContainerPositions.iterator();
            while (it.hasNext()) {
                DimPos dimPos = it.next();
                if (!dimPos.isLoaded()) continue;
                IVariableContainer variableContainer2 = BlockEntityHelpers.getCapability((DimPos)dimPos, null, Capabilities.VariableContainer.BLOCK).orElse(null);
                if (variableContainer2 != null) {
                    compositeMap.addElement(variableContainer2.getVariableCache());
                    continue;
                }
                IntegratedDynamics.clog(Level.ERROR, "The variable container at " + dimPos + " was invalid, skipping.");
                it.remove();
            }
            for (PartPos partPos : this.partPositions.values()) {
                if (!partPos.getPos().isLoaded()) continue;
                IPartContainer partContainer = PartHelpers.getPartContainerChecked(partPos.getPos(), partPos.getSide());
                partContainer.getCapability(Capabilities.VariableContainer.PART, this.network, this, PartTarget.fromCenter(partPos)).ifPresent(variableContainer -> compositeMap.addElement(variableContainer.getVariableCache()));
            }
            this.compositeVariableCache = compositeMap;
        }
        return this.compositeVariableCache;
    }

    @Override
    public boolean hasVariableFacade(int variableId) {
        return this.getVariableCache().containsKey(variableId);
    }

    @Override
    public IVariableFacade getVariableFacade(int variableId) {
        return this.getVariableCache().get(variableId);
    }

    @Override
    public void setValue(int id, IValue value) {
        this.lazyExpressionValueCache.put(id, (Object)value);
    }

    @Override
    public boolean hasValue(int id) {
        return this.lazyExpressionValueCache.containsKey(id);
    }

    @Override
    public IValue getValue(int id) {
        return (IValue)this.lazyExpressionValueCache.get(id);
    }

    @Override
    public void removeValue(int id) {
        this.lazyExpressionValueCache.remove(id);
    }

    @Override
    public boolean addVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        return this.variableContainerPositions.add(dimPos);
    }

    @Override
    public void removeVariableContainer(DimPos dimPos) {
        this.compositeVariableCache = null;
        this.variableContainerPositions.remove(dimPos);
    }

    @Override
    public boolean addProxy(int proxyId, DimPos dimPos) {
        if (this.proxyPositions.containsKey(proxyId)) {
            return false;
        }
        this.proxyPositions.put(proxyId, (Object)dimPos);
        return true;
    }

    @Override
    public void removeProxy(int proxyId) {
        this.proxyPositions.remove(proxyId);
    }

    @Override
    public DimPos getProxy(int proxyId) {
        return (DimPos)this.proxyPositions.get(proxyId);
    }

    @Override
    public void notifyPartsChanged() {
        this.partsChanged = true;
    }

    private void onPartsChanged() {
    }

    @Override
    public void update() {
        if (this.partsChanged) {
            this.partsChanged = false;
            this.onPartsChanged();
        }
    }

    @Override
    public boolean removePathElement(IPathElement pathElement, Direction side) {
        this.notifyPartsChanged();
        return true;
    }

    @Override
    public void invalidateElement(INetworkElement element) {
        this.compositeVariableCache = null;
        super.invalidateElement(element);
    }

    @Override
    public void revalidateElement(INetworkElement element) {
        this.compositeVariableCache = null;
        super.revalidateElement(element);
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(INetwork network) {
        this.network = network;
    }
}

