/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.cyclopscore.recipe.type.IInventoryFluid;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeDryingBasin
implements Recipe<IInventoryFluid> {
    private final Optional<Ingredient> inputIngredient;
    private final Optional<FluidStack> inputFluid;
    private final Optional<Either<ItemStack, ItemStackFromIngredient>> outputItem;
    private final Optional<FluidStack> outputFluid;
    private final int duration;

    public RecipeDryingBasin(Optional<Ingredient> inputIngredient, Optional<FluidStack> inputFluid, Optional<Either<ItemStack, ItemStackFromIngredient>> outputIngredient, Optional<FluidStack> outputFluid, int duration) {
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.outputItem = outputIngredient;
        this.outputFluid = outputFluid;
        this.duration = duration;
    }

    public Optional<Ingredient> getInputIngredient() {
        return this.inputIngredient;
    }

    public Optional<FluidStack> getInputFluid() {
        return this.inputFluid;
    }

    public Optional<Either<ItemStack, ItemStackFromIngredient>> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().get().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public Optional<FluidStack> getOutputFluid() {
        return this.outputFluid;
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean matches(IInventoryFluid inv, Level worldIn) {
        return this.inputIngredient.map(p -> p.test(inv.getItem(0))).orElse(true) != false && this.inputFluid.map(f -> f.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid()).orElse(true) != false && this.inputFluid.map(f -> f.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount()).orElse(true) != false;
    }

    public ItemStack assemble(IInventoryFluid inv, RegistryAccess registryAccess) {
        return this.getOutputItemFirst().copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.getOutputItemFirst().copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_DRYING_BASIN.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get();
    }
}

