/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;

public class RecipeEnergyContainerCombination
extends CustomRecipe {
    private final Ingredient batteryItem;
    private final int maxCapacity;

    public RecipeEnergyContainerCombination(Ingredient batteryItem, int maxCapacity) {
        super(CraftingBookCategory.MISC);
        this.batteryItem = batteryItem;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getBatteryItem() {
        return this.batteryItem;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid, world.registryAccess()).isEmpty();
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.batteryItem.getItems()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            aitemstack.set(i, (Object)CommonHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_ENERGY_CONTAINER_COMBINATION.get();
    }

    public ItemStack assemble(CraftingContainer grid, RegistryAccess registryAccess) {
        ItemStack output = this.getResultItem(registryAccess).copy();
        IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)output.getCapability(Capabilities.EnergyStorage.ITEM);
        int totalCapacity = 0;
        int totalEnergy = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.getContainerSize(); ++j) {
            ItemStack element = grid.getItem(j).copy().split(1);
            if (element.isEmpty()) continue;
            if (this.batteryItem.test(element)) {
                IEnergyStorageCapacity currentEnergyStorage = (IEnergyStorageCapacity)element.getCapability(Capabilities.EnergyStorage.ITEM);
                ++inputItems;
                totalEnergy = Helpers.addSafe((int)totalEnergy, (int)currentEnergyStorage.getEnergyStored());
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)currentEnergyStorage.getMaxEnergyStored());
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.EMPTY;
        }
        energyStorage.setCapacity(totalCapacity);
        ((IEnergyStorageMutable)((Object)energyStorage)).setEnergy(totalEnergy);
        return output;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 9;
    }
}

