/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class RecipeSerializerDryingBasin
implements RecipeSerializer<RecipeDryingBasin> {
    public static final Codec<RecipeDryingBasin> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.strictOptionalField((Codec)Ingredient.CODEC_NONEMPTY, (String)"input_item").forGetter(RecipeDryingBasin::getInputIngredient), (App)ExtraCodecs.strictOptionalField((Codec)FluidStack.CODEC, (String)"input_fluid").forGetter(RecipeDryingBasin::getInputFluid), (App)ExtraCodecs.strictOptionalField((Codec)RecipeSerializerHelpers.getCodecItemStackOrTag(() -> GeneralConfig.recipeTagOutputModPriorities), (String)"output_item").forGetter(RecipeDryingBasin::getOutputItem), (App)ExtraCodecs.strictOptionalField((Codec)FluidStack.CODEC, (String)"output_fluid").forGetter(RecipeDryingBasin::getOutputFluid), (App)Codec.INT.fieldOf("duration").forGetter(RecipeDryingBasin::getDuration)).apply((Applicative)builder, (inputItem, inputFluid, outputItem, outputFluid, duration) -> {
        if (inputItem.isEmpty() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItem.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (inputFluid.isPresent() && outputFluid.isPresent()) {
            throw new JsonSyntaxException("Can't have both an input and output fluid");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeDryingBasin((Optional<Ingredient>)inputItem, (Optional<FluidStack>)inputFluid, (Optional<Either<ItemStack, ItemStackFromIngredient>>)outputItem, (Optional<FluidStack>)outputFluid, (int)duration);
    }));

    public Codec<RecipeDryingBasin> codec() {
        return CODEC;
    }

    @Nullable
    public RecipeDryingBasin fromNetwork(FriendlyByteBuf buffer) {
        Optional inputIngredient = RecipeSerializerHelpers.readOptionalFromNetwork((FriendlyByteBuf)buffer, Ingredient::fromNetwork);
        Optional inputFluid = RecipeSerializerHelpers.readOptionalFromNetwork((FriendlyByteBuf)buffer, FluidStack::readFromPacket);
        Optional outputItem = RecipeSerializerHelpers.readOptionalFromNetwork((FriendlyByteBuf)buffer, RecipeSerializerHelpers::readItemStackOrItemStackIngredient);
        Optional outputFluid = RecipeSerializerHelpers.readOptionalFromNetwork((FriendlyByteBuf)buffer, FluidStack::readFromPacket);
        int duration = buffer.readVarInt();
        return new RecipeDryingBasin(inputIngredient, inputFluid, outputItem, outputFluid, duration);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeDryingBasin recipe) {
        RecipeSerializerHelpers.writeOptionalToNetwork((FriendlyByteBuf)buffer, recipe.getInputIngredient(), (b, value) -> value.toNetwork(b));
        RecipeSerializerHelpers.writeOptionalToNetwork((FriendlyByteBuf)buffer, recipe.getInputFluid(), (b, value) -> value.writeToPacket(b));
        RecipeSerializerHelpers.writeOptionalToNetwork((FriendlyByteBuf)buffer, recipe.getOutputItem(), RecipeSerializerHelpers::writeItemStackOrItemStackIngredient);
        RecipeSerializerHelpers.writeOptionalToNetwork((FriendlyByteBuf)buffer, recipe.getOutputFluid(), (b, value) -> value.writeToPacket(b));
        buffer.writeVarInt(recipe.getDuration());
    }
}

