/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeEnergyContainerCombination;

public class RecipeSerializerEnergyContainerCombination
implements RecipeSerializer<RecipeEnergyContainerCombination> {
    public static final Codec<RecipeEnergyContainerCombination> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(RecipeEnergyContainerCombination::getBatteryItem), (App)Codec.INT.fieldOf("maxCapacity").forGetter(RecipeEnergyContainerCombination::getMaxCapacity)).apply((Applicative)builder, RecipeEnergyContainerCombination::new));

    public Codec<RecipeEnergyContainerCombination> codec() {
        return CODEC;
    }

    @Nullable
    public RecipeEnergyContainerCombination fromNetwork(FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        int maxCapacity = buffer.readInt();
        return new RecipeEnergyContainerCombination(inputIngredient, maxCapacity);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeEnergyContainerCombination recipe) {
        recipe.getBatteryItem().toNetwork(buffer);
        buffer.writeInt(recipe.getMaxCapacity());
    }
}

