/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.codec.ListCodecStrict;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSerializerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerMechanicalSqueezer
implements RecipeSerializer<RecipeMechanicalSqueezer> {
    public static final Codec<RecipeMechanicalSqueezer> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input_item").forGetter(RecipeSqueezer::getInputIngredient), (App)ExtraCodecs.strictOptionalField((Codec)new ListCodecStrict(RecipeSerializerSqueezer.CODEC_INGREDIENT_CHANCE), (String)"output_items").forGetter(r -> r.getOutputItems().isEmpty() ? Optional.empty() : Optional.of(r.getOutputItems().stream().toList())), (App)ExtraCodecs.strictOptionalField((Codec)FluidStack.CODEC, (String)"output_fluid").forGetter(RecipeSqueezer::getOutputFluid), (App)Codec.INT.fieldOf("duration").forGetter(RecipeMechanicalSqueezer::getDuration)).apply((Applicative)builder, (inputIngredient, outputItemStacks, outputFluid, duration) -> {
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeMechanicalSqueezer((Ingredient)inputIngredient, (NonNullList<RecipeSqueezer.IngredientChance>)outputItemStacks.map(NonNullList::copyOf).orElseGet(NonNullList::create), (Optional<FluidStack>)outputFluid, (int)duration);
    }));

    public Codec<RecipeMechanicalSqueezer> codec() {
        return CODEC;
    }

    @Nullable
    public RecipeMechanicalSqueezer fromNetwork(FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        NonNullList outputItemStacks = NonNullList.create();
        int outputItemStacksCount = buffer.readInt();
        for (int i = 0; i < outputItemStacksCount; ++i) {
            outputItemStacks.add((Object)new RecipeSqueezer.IngredientChance((Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>>)RecipeSerializerHelpers.readItemStackOrItemStackIngredientChance((FriendlyByteBuf)buffer)));
        }
        Optional outputFluid = RecipeSerializerHelpers.readOptionalFromNetwork((FriendlyByteBuf)buffer, FluidStack::readFromPacket);
        int duration = buffer.readVarInt();
        return new RecipeMechanicalSqueezer(inputIngredient, (NonNullList<RecipeSqueezer.IngredientChance>)outputItemStacks, outputFluid, duration);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeMechanicalSqueezer recipe) {
        recipe.getInputIngredient().toNetwork(buffer);
        buffer.writeInt(recipe.getOutputItems().size());
        for (RecipeSqueezer.IngredientChance outputItem : recipe.getOutputItems()) {
            RecipeSerializerHelpers.writeItemStackOrItemStackIngredientChance((FriendlyByteBuf)buffer, outputItem.getIngredientChance());
        }
        RecipeSerializerHelpers.writeOptionalToNetwork((FriendlyByteBuf)buffer, recipe.getOutputFluid(), (b, value) -> value.writeToPacket(b));
        buffer.writeVarInt(recipe.getDuration());
    }
}

