/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeSqueezer
implements Recipe<Container> {
    private final Ingredient inputIngredient;
    private final NonNullList<IngredientChance> outputItems;
    private final Optional<FluidStack> outputFluid;

    public RecipeSqueezer(Ingredient inputIngredient, NonNullList<IngredientChance> outputItems, Optional<FluidStack> outputFluid) {
        this.inputIngredient = inputIngredient;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public NonNullList<IngredientChance> getOutputItems() {
        return this.outputItems;
    }

    public Optional<FluidStack> getOutputFluid() {
        return this.outputFluid;
    }

    public boolean matches(Container inv, Level worldIn) {
        return this.inputIngredient.test(inv.getItem(0));
    }

    public ItemStack assemble(Container inv, RegistryAccess registryAccess) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((IngredientChance)this.outputItems.get(0)).getIngredientFirst().copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((IngredientChance)this.outputItems.get(0)).getIngredientFirst().copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_SQUEEZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get();
    }

    public static class IngredientChance {
        private final Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> ingredient;

        public IngredientChance(Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> ingredient) {
            this.ingredient = Objects.requireNonNull(ingredient);
        }

        public Either<ItemStack, ItemStackFromIngredient> getIngredient() {
            return this.ingredient.mapBoth(Pair::getLeft, Pair::getLeft);
        }

        public Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> getIngredientChance() {
            return this.ingredient;
        }

        public ItemStack getIngredientFirst() {
            return (ItemStack)this.getIngredient().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
        }

        public float getChance() {
            return ((Float)this.ingredient.map(Pair::getRight, Pair::getRight)).floatValue();
        }
    }
}

