/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.infobook;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoBook;
import org.cyclops.cyclopscore.infobook.InfoBookParser;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendix;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.infobook.pageelement.AspectAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.DryingBasinRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.MechanicalDryingBasinRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.MechanicalSqueezerRecipeAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.OperatorAppendix;
import org.cyclops.integrateddynamics.infobook.pageelement.SqueezerRecipeAppendix;
import org.cyclops.integrateddynamics.part.aspect.Aspects;
import org.w3c.dom.Element;

public class OnTheDynamicsOfIntegrationBook
extends InfoBook {
    private static OnTheDynamicsOfIntegrationBook _instance = null;

    private OnTheDynamicsOfIntegrationBook() {
        super((ModBase)IntegratedDynamics._instance, 2, "https://integrateddynamics.rubensworks.net/book/");
    }

    public static synchronized OnTheDynamicsOfIntegrationBook getInstance() {
        if (_instance == null) {
            _instance = new OnTheDynamicsOfIntegrationBook();
        }
        return _instance;
    }

    static {
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_SQUEEZER.get()), SqueezerRecipeAppendix::new);
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER.get()), MechanicalSqueezerRecipeAppendix::new);
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get()), DryingBasinRecipeAppendix::new);
        InfoBookParser.registerAppendixRecipeFactories((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN.get()), MechanicalDryingBasinRecipeAppendix::new);
        InfoBookParser.registerAppendixFactory((String)"integrateddynamics:aspect", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String aspectName = node.getTextContent();
                IAspect aspect = Aspects.REGISTRY.getAspect(new ResourceLocation(aspectName));
                if (aspect == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an aspect by name %s.", aspectName));
                }
                return new AspectAppendix(infoBook, aspect);
            }
        });
        InfoBookParser.registerAppendixListFactory((String)"integrateddynamics:part_aspects", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String partName = node.getTextContent();
                IPartType partType = PartTypes.REGISTRY.getPartType(new ResourceLocation(partName));
                if (partType == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find a part type by name '%s'.", partName));
                }
                ArrayList aspects = Lists.newArrayList(Aspects.REGISTRY.getAspects(partType));
                return Lists.transform((List)aspects, (Function)new Function<IAspect, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IAspect input) {
                        return new AspectAppendix(infoBook, input);
                    }
                });
            }
        });
        InfoBookParser.registerAppendixFactory((String)"integrateddynamics:operator", (InfoBookParser.IAppendixFactory)new InfoBookParser.IAppendixFactory(){

            public SectionAppendix create(IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String operatorName = node.getTextContent();
                IOperator operator = Operators.REGISTRY.getOperator(new ResourceLocation(operatorName));
                if (operator == null) {
                    throw new InfoBookParser.InvalidAppendixException(String.format("Could not find an operator by name %s.", operatorName));
                }
                return new OperatorAppendix(infoBook, operator);
            }
        });
        InfoBookParser.registerAppendixListFactory((String)"integrateddynamics:operators_output", (InfoBookParser.IAppendixListFactory)new InfoBookParser.IAppendixListFactory(){

            public List<SectionAppendix> create(final IInfoBook infoBook, Element node) throws InfoBookParser.InvalidAppendixException {
                String categoryName = node.getTextContent();
                ArrayList operators = Lists.newArrayList("*".equals(categoryName) ? Operators.REGISTRY.getOperators() : Operators.REGISTRY.getOperatorsInCategory(categoryName));
                return Lists.transform((List)operators, (Function)new Function<IOperator, SectionAppendix>(){

                    @Nullable
                    public SectionAppendix apply(IOperator input) {
                        return new OperatorAppendix(infoBook, input);
                    }
                });
            }
        });
    }
}

