/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;

public class ItemBlockCable
extends BlockItem {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();

    public ItemBlockCable(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    protected boolean checkCableAt(Level world, BlockPos pos, @Nullable Direction side) {
        if (!CableHelpers.isNoFakeCable((ILevelExtension)world, pos, side) && CableHelpers.getCable((ILevelExtension)world, pos, side) != null) {
            return true;
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.canPlaceAt(world, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState blockState) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockPos target = pos.relative(side);
        if (this.checkCableAt(world, pos, side)) {
            return true;
        }
        if (this.checkCableAt(world, target, side.getOpposite())) {
            return true;
        }
        return !this.mustSurvive() || blockState.canSurvive((LevelReader)context.getLevel(), target);
    }

    protected boolean attempItemUseTarget(UseOnContext context, BlockPos pos, Direction side, BlockCable blockCable, boolean offsetAdded) {
        BlockState blockState = context.getLevel().getBlockState(pos);
        if (!context.getLevel().isEmptyBlock(pos)) {
            ICableFakeable cable = CableHelpers.getCableFakeable((ILevelExtension)context.getLevel(), pos, side).orElse(null);
            if (cable != null && !cable.isRealCable()) {
                if (!context.getLevel().isClientSide()) {
                    cable.setRealCable(true);
                    CableHelpers.updateConnections((ILevelExtension)context.getLevel(), pos, side);
                    CableHelpers.onCableAdded(context.getLevel(), pos);
                    CableHelpers.onCableAddedByPlayer(context.getLevel(), pos, (LivingEntity)context.getPlayer());
                }
                return true;
            }
            if (!offsetAdded) {
                for (IUseAction useAction : USE_ACTIONS) {
                    if (!useAction.attempItemUseTarget(context.getItemInHand(), context.getLevel(), pos, blockCable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void afterItemUse(UseOnContext context, BlockPos pos, BlockCable blockCable, boolean calledSuper) {
        if (!calledSuper) {
            ItemBlockCable.playPlaceSound(context.getLevel(), pos);
            if (context.getItemInHand().getItem() == RegistryEntries.ITEM_CABLE.get()) {
                context.getItemInHand().shrink(1);
            }
        }
        blockCable.setDisableCollisionBox(false);
    }

    public static void playPlaceSound(Level world, BlockPos pos) {
        Block block = (Block)RegistryEntries.BLOCK_CABLE.get();
        SoundType soundType = block.getSoundType(block.defaultBlockState());
        world.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f, false);
    }

    public static void playBreakSound(Level world, BlockPos pos, BlockState blockState) {
        world.globalLevelEvent(2001, pos, Block.getId((BlockState)blockState));
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack itemStack = context.getItemInHand();
        BlockCable blockCable = (BlockCable)this.getBlock();
        blockCable.setDisableCollisionBox(true);
        if (this.attempItemUseTarget(context, context.getClickedPos(), context.getClickedFace(), blockCable, false)) {
            this.afterItemUse(context, context.getClickedPos(), blockCable, false);
            return InteractionResult.SUCCESS;
        }
        BlockPos posOffset = context.getClickedPos().relative(context.getClickedFace());
        if (this.attempItemUseTarget(context, posOffset, context.getClickedFace().getOpposite(), blockCable, true)) {
            this.afterItemUse(context, posOffset, blockCable, false);
            return InteractionResult.SUCCESS;
        }
        InteractionResult ret = super.useOn(context);
        this.afterItemUse(context, context.getClickedPos(), blockCable, true);
        return ret;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemStack var1, Level var2, BlockPos var3, BlockCable var4);

        public boolean canPlaceAt(Level var1, BlockPos var2);
    }
}

