/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;

public class ItemEnhancement
extends Item {
    private final Type type;

    public ItemEnhancement(Type type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public <P extends IPartType<P, S>, S extends IPartState<P>> InteractionResult applyEnhancement(IPartType<P, S> partType, IPartState<P> partState, ItemStack itemStack, Player player, InteractionHand hand) {
        switch (this.type) {
            case OFFSET: {
                if (!partType.supportsOffsets()) break;
                int value = this.getEnhancementValue(itemStack);
                int newValue = partState.getMaxOffset() + value;
                if (newValue < GeneralConfig.maxPartOffset) {
                    if (!player.level().isClientSide()) {
                        partState.setMaxOffset(newValue);
                    }
                    itemStack.shrink(1);
                    player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.increased", (Object[])new Object[]{newValue}), true);
                    return InteractionResult.SUCCESS;
                }
                player.displayClientMessage((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.limit", (Object[])new Object[]{GeneralConfig.maxPartOffset}), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getEnhancementValue(ItemStack itemStack) {
        return itemStack.getOrCreateTag().getInt("value");
    }

    public void setEnhancementValue(ItemStack itemStack, int value) {
        itemStack.getOrCreateTag().putInt("value", value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"item.integrateddynamics.enhancement_offset.tooltip", (Object[])new Object[]{this.getEnhancementValue(itemStack)}).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(itemStack, world, list, flag);
    }

    public static enum Type {
        OFFSET;

    }
}

