/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHolder;
import org.cyclops.integrateddynamics.client.render.blockentity.ItemStackBlockEntityVariableRender;
import org.cyclops.integrateddynamics.core.item.VariableFacadeHandlerRegistry;

public class ItemVariable
extends Item {
    public ItemVariable(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        IVariableFacade variableFacade = this.getVariableFacade(ValueDeseralizationContext.of(world), itemStack);
        variableFacade.appendHoverText(list, world);
        if (variableFacade != VariableFacadeHandlerRegistry.DUMMY_FACADE && Minecraft.getInstance().player != null && Minecraft.getInstance().player.isCreative()) {
            list.add((Component)Component.translatable((String)"item.integrateddynamics.variable.warning"));
        }
        super.appendHoverText(itemStack, world, list, flag);
    }

    public Component getName(ItemStack itemStack) {
        String label;
        IVariableFacade variableFacade = this.getVariableFacade(ValueDeseralizationContext.ofAllEnabled(), itemStack);
        if (variableFacade.isValid() && (label = variableFacade.getLabel()) != null) {
            return Component.literal((String)label).withStyle(ChatFormatting.ITALIC);
        }
        return super.getName(itemStack);
    }

    public IVariableFacade getVariableFacade(ValueDeseralizationContext valueDeseralizationContext, ItemStack itemStack) {
        IVariableFacadeHolder holder = (IVariableFacadeHolder)itemStack.getCapability(Capabilities.VariableFacade.ITEM);
        if (holder != null) {
            return holder.getVariableFacade(valueDeseralizationContext);
        }
        return VariableFacadeHandlerRegistry.DUMMY_FACADE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new ItemStackBlockEntityVariableRender();
            }
        });
    }
}

